/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;

public class Registry {
    private static final Logger log = Logger.getLogger(Registry.class);
    public static Map<Object, Object> entries = new ConcurrentHashMap<Object, Object>();
    private static RuntimePermission perm = new RuntimePermission(Registry.class.getName());

    public static void bind(Object key, Object value) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(perm);
        }
        entries.put(key, value);
        if (log.isTraceEnabled()) {
            log.trace((Object)("bound " + key + "=" + value));
        }
    }

    public static Object unbind(Object key) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(perm);
        }
        Object obj = entries.remove(key);
        if (log.isTraceEnabled()) {
            log.trace((Object)("unbound " + key + "=" + obj));
        }
        return obj;
    }

    public static Object lookup(Object key) {
        Object obj = entries.get(key);
        if (log.isTraceEnabled()) {
            log.trace((Object)("lookup " + key + "=" + obj));
        }
        return obj;
    }
}

