/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.serviceBinding;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.RunState;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.plugins.jbossas5.ManagedComponentComponent;
import org.rhq.plugins.jbossas5.serviceBinding.Util;

public class ManagerComponent
extends ManagedComponentComponent
implements CreateChildResourceFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String BINDING_PROPERTY = "binding";
    private static final String BINDING_SET_SERVICE_NAME = "Service Binding Set";
    private static final String RESOURCE_KEY_SEPARATOR = "!)@(#*";

    public AvailabilityType getAvailability() {
        RunState runState = this.getManagedComponent().getRunState();
        return runState == RunState.RUNNING || runState == RunState.UNKNOWN ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public Configuration loadResourceConfiguration() {
        ManagedComponent bindingManagerComponent = this.getBindingManager();
        Configuration configuration = new Configuration();
        String activeBindingSetName = Util.getValue((SimpleValue)bindingManagerComponent.getProperty("activeBindingSetName").getValue(), String.class);
        configuration.put((Property)new PropertySimple("activeBindingSetName", (Object)activeBindingSetName));
        CollectionValue standardBindings = (CollectionValue)bindingManagerComponent.getProperty("standardBindings").getValue();
        PropertyList bindings = new PropertyList("standardBindings");
        configuration.put((Property)bindings);
        for (MetaValue b : standardBindings.getElements()) {
            CompositeValue binding = (CompositeValue)b;
            PropertyMap bindingMap = new PropertyMap(BINDING_PROPERTY);
            bindings.add((Property)bindingMap);
            for (PropertySimple prop : Util.getProperties(Arrays.asList(Util.STANDARD_BINDING_PROPERTIES), binding)) {
                bindingMap.put((Property)prop);
            }
        }
        return configuration;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
        try {
            Configuration updatedConfiguration = configurationUpdateReport.getConfiguration();
            ManagedComponent bindingManagerComponent = this.getBindingManager();
            ManagedProperty bindingSetsProperty = bindingManagerComponent.getProperty("bindingSets");
            CollectionValue bindingSets = (CollectionValue)bindingSetsProperty.getValue();
            String updatedActiveBindingSetName = updatedConfiguration.getSimpleValue("activeBindingSetName", null);
            if (updatedActiveBindingSetName == null || updatedActiveBindingSetName.trim().length() == 0) {
                configurationUpdateReport.setErrorMessage("Active binding set name must be set.");
                configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
            }
            boolean found = false;
            for (MetaValue bindingSet : bindingSets) {
                CompositeValue bindingSetComposite = (CompositeValue)bindingSet;
                String bindingSetName = Util.getValue(bindingSetComposite, "name", String.class);
                if (!updatedActiveBindingSetName.equals(bindingSetName)) continue;
                found = true;
                break;
            }
            if (!found) {
                configurationUpdateReport.setErrorMessage("A binding set with the provided name does not exist - cannot set it as active.");
                configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
                return;
            }
            bindingManagerComponent.getProperty("activeBindingSetName").setValue((MetaValue)Util.wrap(updatedConfiguration.getSimple("activeBindingSetName"), String.class));
            PropertyList standardBindingsList = updatedConfiguration.getList("standardBindings");
            MetaValue[] standarBindingsArray = new MetaValue[standardBindingsList.getList().size()];
            CollectionValueSupport standardBindingsValue = new CollectionValueSupport((CollectionMetaType)bindingManagerComponent.getProperty("standardBindings").getMetaType());
            standardBindingsValue.setElements(standarBindingsArray);
            ImmutableCompositeMetaType bindingMetaType = (ImmutableCompositeMetaType)standardBindingsValue.getMetaType().getElementType();
            int i = 0;
            for (Property p : standardBindingsList.getList()) {
                PropertyMap standardBindingMap = (PropertyMap)p;
                MapCompositeValueSupport binding = new MapCompositeValueSupport((MetaType)bindingMetaType);
                for (Util.PropertyDefinition def : Util.STANDARD_BINDING_PROPERTIES) {
                    binding.put(def.propertyName, (MetaValue)Util.wrap(standardBindingMap.getSimple(def.propertyName), def.propertyType));
                }
                standarBindingsArray[i++] = binding;
            }
            bindingManagerComponent.getProperty("standardBindings").setValue((MetaValue)standardBindingsValue);
            this.updateBindingManager(bindingManagerComponent);
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to update SBM configuration.", (Throwable)e);
            configurationUpdateReport.setErrorMessageFromThrowable((Throwable)e);
            configurationUpdateReport.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        try {
            if (BINDING_SET_SERVICE_NAME.equals(report.getResourceType().getName())) {
                Configuration bindingConfiguration = report.getResourceConfiguration();
                this.checkValidity(bindingConfiguration);
                CompositeValue newBindingSet = Util.getBindingSetFromConfiguration(this.getBindingSetValueMetaType(), bindingConfiguration);
                ManagedComponent bindingManagerComponent = this.getBindingManager();
                ManagedProperty bindingSetsProperty = bindingManagerComponent.getProperty("bindingSets");
                CollectionValue bindingSets = (CollectionValue)bindingSetsProperty.getValue();
                String newBindingSetName = Util.getValue(newBindingSet, "name", String.class);
                for (MetaValue bindingSet : bindingSets) {
                    CompositeValue bindingSetComposite = (CompositeValue)bindingSet;
                    String bindingSetName = Util.getValue(bindingSetComposite, "name", String.class);
                    if (!newBindingSetName.equals(bindingSetName)) continue;
                    report.setErrorMessage("A binding set with the provided name already exists.");
                    report.setStatus(CreateResourceStatus.FAILURE);
                    return report;
                }
                MetaValue[] newBindingSets = new MetaValue[bindingSets.getSize() + 1];
                System.arraycopy(bindingSets.getElements(), 0, newBindingSets, 0, bindingSets.getSize());
                newBindingSets[bindingSets.getSize()] = newBindingSet;
                CollectionValueSupport newBindingSetsValue = new CollectionValueSupport(bindingSets.getMetaType());
                newBindingSetsValue.setElements(newBindingSets);
                bindingSetsProperty.setValue((MetaValue)newBindingSetsValue);
                this.updateBindingManager(bindingManagerComponent);
                report.setResourceKey(this.getBindingSetResourceKey(newBindingSetName));
                report.setResourceName(newBindingSetName);
                report.setStatus(CreateResourceStatus.SUCCESS);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to create service " + report.getResourceType().getName()), (Throwable)e);
            report.setException((Throwable)e);
            report.setStatus(CreateResourceStatus.FAILURE);
        }
        return report;
    }

    public MetaType getBindingSetValueMetaType() {
        CollectionMetaType bindingSetsMetaType = (CollectionMetaType)this.getBindingManager().getProperty("bindingSets").getMetaType();
        return bindingSetsMetaType.getElementType();
    }

    public ManagedComponent getBindingManager() {
        return this.getManagedComponent();
    }

    public void updateBindingManager(ManagedComponent bindingManagerComponent) throws Exception {
        ManagementView managementView = this.getConnection().getManagementView();
        managementView.updateComponent(bindingManagerComponent);
        managementView.load();
    }

    public String getBindingSetResourceKey(String bindingSetName) {
        return this.getResourceContext().getResourceKey() + RESOURCE_KEY_SEPARATOR + bindingSetName;
    }

    public String getBindingSetNameFromResourceKey(String resourceKey) {
        int separatorIdx = resourceKey.lastIndexOf(RESOURCE_KEY_SEPARATOR);
        return resourceKey.substring(separatorIdx + RESOURCE_KEY_SEPARATOR.length());
    }

    public void checkValidity(Configuration bindingSetConfiguration) throws IllegalArgumentException, UnknownHostException {
        String name = bindingSetConfiguration.getSimpleValue("name", null);
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Name of the binding set must not be empty.");
        }
        String defaultHostName = bindingSetConfiguration.getSimpleValue("defaultHostName", null);
        if (defaultHostName == null || defaultHostName.trim().length() == 0) {
            throw new IllegalArgumentException("The default host name of the binding set must not be empty.");
        }
        InetAddress.getByName(defaultHostName);
    }
}

