/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc2.query;

import java.util.Properties;
import javax.transaction.Transaction;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.jbc2.TransactionalDataRegionAdapter;
import org.hibernate.cache.jbc2.util.CacheHelper;
import org.hibernate.util.PropertiesHelper;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Option;
import org.jboss.cache.notifications.annotation.CacheListener;

@CacheListener
public class QueryResultsRegionImpl
extends TransactionalDataRegionAdapter
implements QueryResultsRegion {
    public static final String QUERY_CACHE_LOCAL_ONLY_PROP = "hibernate.cache.region.jbc2.query.localonly";
    public static final String TYPE = "QUERY";
    private boolean localOnly;

    public QueryResultsRegionImpl(Cache jbcCache, String regionName, String regionPrefix, Properties properties) {
        super(jbcCache, regionName, regionPrefix, null);
        this.localOnly = CacheHelper.isClusteredInvalidation(jbcCache);
        if (!this.localOnly) {
            this.localOnly = CacheHelper.isClusteredReplication(jbcCache) && PropertiesHelper.getBoolean((String)QUERY_CACHE_LOCAL_ONLY_PROP, (Properties)properties, (boolean)false);
        }
    }

    public void evict(Object key) throws CacheException {
        this.ensureRegionRootExists();
        Option opt = this.getNonLockingDataVersionOption(false);
        if (this.localOnly) {
            opt.setCacheModeLocal(true);
        }
        CacheHelper.removeNode(this.getCacheInstance(), this.getRegionFqn(), key, opt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() throws CacheException {
        Transaction tx = this.suspend();
        try {
            this.ensureRegionRootExists();
            Option opt = this.getNonLockingDataVersionOption(true);
            CacheHelper.sendEvictAllNotification(this.jbcCache, this.regionFqn, this.getMemberId(), opt);
        }
        finally {
            this.resume(tx);
        }
    }

    public Object get(Object key) throws CacheException {
        if (!this.checkValid()) {
            return null;
        }
        this.ensureRegionRootExists();
        Option opt = new Option();
        opt.setLockAcquisitionTimeout(0);
        return this.suspendAndGet(key, opt, true);
    }

    public void put(Object key, Object value) throws CacheException {
        if (this.checkValid()) {
            this.ensureRegionRootExists();
            Option opt = this.getNonLockingDataVersionOption(false);
            opt.setLockAcquisitionTimeout(2);
            if (this.localOnly) {
                opt.setCacheModeLocal(true);
            }
            CacheHelper.putAllowingTimeout(this.getCacheInstance(), this.getRegionFqn(), key, value, opt);
        }
    }

    @Override
    protected Fqn<String> createRegionFqn(String regionName, String regionPrefix) {
        return QueryResultsRegionImpl.getTypeLastRegionFqn(regionName, regionPrefix, TYPE);
    }
}

