/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.MappingException;
import org.hibernate.mapping.List;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.CollectionType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ReflectHelper;

public class Array
extends List {
    private String elementClassName;

    public Array(PersistentClass owner) {
        super(owner);
    }

    public Class getElementClass() throws MappingException {
        if (this.elementClassName == null) {
            Type elementType = this.getElement().getType();
            return this.isPrimitiveArray() ? ((PrimitiveType)elementType).getPrimitiveClass() : elementType.getReturnedClass();
        }
        try {
            return ReflectHelper.classForName(this.elementClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException(cnfe);
        }
    }

    @Override
    public CollectionType getDefaultCollectionType() throws MappingException {
        return TypeFactory.array(this.getRole(), this.getReferencedPropertyName(), this.isEmbedded(), this.getElementClass());
    }

    @Override
    public boolean isArray() {
        return true;
    }

    public String getElementClassName() {
        return this.elementClassName;
    }

    public void setElementClassName(String elementClassName) {
        this.elementClassName = elementClassName;
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }
}

