/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.BooleanType;

public class NumericBooleanType
extends BooleanType {
    @Override
    public String getName() {
        return "numeric_boolean";
    }

    @Override
    public Object get(ResultSet rs, String name) throws SQLException {
        int value = rs.getInt(name);
        if (rs.wasNull()) {
            return this.getDefaultValue();
        }
        if (value == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        if (value == null) {
            st.setNull(index, 4);
        } else {
            boolean bool = (Boolean)value;
            st.setInt(index, bool ? 1 : 0);
        }
    }

    @Override
    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return (Boolean)value != false ? "1" : "0";
    }

    @Override
    public int sqlType() {
        return 4;
    }
}

