/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jboss.xnio.ConfigurableFactory;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.BoundServer;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.nio.AbstractConfigurable;
import org.jboss.xnio.nio.NioTcpServer;
import org.jboss.xnio.nio.NioTcpServerConfig;
import org.jboss.xnio.nio.NioXnio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioTcpServerFactory
extends AbstractConfigurable
implements ConfigurableFactory<BoundServer<SocketAddress, BoundChannel<SocketAddress>>> {
    private static final Set<ChannelOption<?>> options;
    private final NioXnio xnio;
    private final Executor executor;
    private final IoHandlerFactory<? super TcpChannel> factory;
    private final SocketAddress[] initialAddresses;
    private final Object lock = new Object();
    private boolean created;

    NioTcpServerFactory(NioXnio xnio, Executor executor, IoHandlerFactory<? super TcpChannel> factory, SocketAddress[] initialAddresses) {
        super(options);
        this.xnio = xnio;
        this.executor = executor;
        this.factory = factory;
        this.initialAddresses = initialAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoundServer<SocketAddress, BoundChannel<SocketAddress>> create() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.created) {
                throw new IllegalStateException("Already created");
            }
            NioTcpServerConfig config = new NioTcpServerConfig();
            config.setXnio(this.xnio);
            config.setExecutor(this.executor);
            config.setHandlerFactory(this.factory);
            config.setInitialAddresses(this.initialAddresses);
            config.setBacklog((Integer)this.getOption(CommonOptions.BACKLOG));
            config.setReuseAddresses((Boolean)this.getOption(CommonOptions.REUSE_ADDRESSES));
            config.setReceiveBuffer((Integer)this.getOption(CommonOptions.RECEIVE_BUFFER));
            config.setKeepAlive((Boolean)this.getOption(CommonOptions.KEEP_ALIVE));
            config.setOobInline((Boolean)this.getOption(CommonOptions.TCP_OOB_INLINE));
            config.setNoDelay((Boolean)this.getOption(CommonOptions.TCP_NODELAY));
            Boolean manage = (Boolean)this.getOption(CommonOptions.MANAGE_CONNECTIONS);
            config.setManageConnections(manage != null ? manage : false);
            NioTcpServer tcpServer = NioTcpServer.create(config);
            this.created = true;
            return tcpServer;
        }
    }

    static {
        HashSet<ChannelOption> optionSet = new HashSet<ChannelOption>();
        optionSet.add(CommonOptions.BACKLOG);
        optionSet.add(CommonOptions.REUSE_ADDRESSES);
        optionSet.add(CommonOptions.RECEIVE_BUFFER);
        optionSet.add(CommonOptions.KEEP_ALIVE);
        optionSet.add(CommonOptions.TCP_OOB_INLINE);
        optionSet.add(CommonOptions.TCP_NODELAY);
        optionSet.add(CommonOptions.MANAGE_CONNECTIONS);
        options = Collections.unmodifiableSet(optionSet);
    }
}

