/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.ejb3.cache.Identifiable;
import org.jboss.ejb3.cache.ObjectStore;
import org.jboss.logging.Logger;
import org.jboss.serial.io.JBossObjectInputStream;
import org.jboss.serial.io.JBossObjectOutputStream;

public class FileObjectStore<T extends Identifiable>
implements ObjectStore<T> {
    private static final Logger log = Logger.getLogger(FileObjectStore.class);
    private File storageDirectory;

    protected File getFile(Object key) {
        return new File(this.storageDirectory, String.valueOf(key) + ".ser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T load(Object key) {
        File file = this.getFile(key);
        if (!file.exists()) {
            return null;
        }
        log.debug((Object)("loading state from " + file));
        try {
            FileInputStream fis = FISAction.open(file);
            JBossObjectInputStream in = new JBossObjectInputStream((InputStream)fis);
            try {
                Identifiable identifiable = (Identifiable)in.readObject();
                return (T)identifiable;
            }
            finally {
                in.close();
                DeleteFileAction.delete(file);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("failed to load object " + key, e);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to load object " + key, e);
        }
    }

    public void setStorageDirectory(String dirName) {
        this.storageDirectory = new File(dirName);
    }

    public void start() {
        assert (this.storageDirectory != null) : "storageDirectory is null";
        if (!this.storageDirectory.exists()) {
            if (!MkdirsFileAction.mkdirs(this.storageDirectory)) {
                throw new RuntimeException("Unable to create storage directory " + this.storageDirectory);
            }
            this.storageDirectory.deleteOnExit();
        }
        if (!this.storageDirectory.isDirectory()) {
            throw new RuntimeException("Storage directory " + this.storageDirectory + " is not a directory");
        }
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(T obj) {
        File file = this.getFile(obj.getId());
        file.deleteOnExit();
        log.debug((Object)("saving state to " + file));
        try {
            FileOutputStream fos = FOSAction.open(file);
            JBossObjectOutputStream out = new JBossObjectOutputStream((OutputStream)fos);
            try {
                out.writeObject(obj);
                out.flush();
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("failed to store object " + obj.getId(), e);
        }
    }

    private static class MkdirsFileAction
    implements PrivilegedAction<Boolean> {
        File file;

        MkdirsFileAction(File file) {
            this.file = file;
        }

        @Override
        public Boolean run() {
            return this.file.mkdirs();
        }

        static boolean mkdirs(File file) {
            MkdirsFileAction action = new MkdirsFileAction(file);
            return AccessController.doPrivileged(action);
        }
    }

    private static class FOSAction
    implements PrivilegedExceptionAction<FileOutputStream> {
        File file;

        FOSAction(File file) {
            this.file = file;
        }

        @Override
        public FileOutputStream run() throws FileNotFoundException {
            FileOutputStream fis = new FileOutputStream(this.file);
            return fis;
        }

        static FileOutputStream open(File file) throws FileNotFoundException {
            FOSAction action = new FOSAction(file);
            FileOutputStream fos = null;
            try {
                fos = AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (FileNotFoundException)e.getException();
            }
            return fos;
        }
    }

    private static class FISAction
    implements PrivilegedExceptionAction<FileInputStream> {
        File file;

        FISAction(File file) {
            this.file = file;
        }

        @Override
        public FileInputStream run() throws FileNotFoundException {
            FileInputStream fis = new FileInputStream(this.file);
            return fis;
        }

        static FileInputStream open(File file) throws FileNotFoundException {
            FISAction action = new FISAction(file);
            FileInputStream fis = null;
            try {
                fis = AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (FileNotFoundException)e.getException();
            }
            return fis;
        }
    }

    private static class DeleteFileAction
    implements PrivilegedAction<Boolean> {
        File file;

        DeleteFileAction(File file) {
            this.file = file;
        }

        @Override
        public Boolean run() {
            return this.file.delete();
        }

        static boolean delete(File file) {
            DeleteFileAction action = new DeleteFileAction(file);
            return AccessController.doPrivileged(action);
        }
    }
}

