/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.password;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static Method getMethod(final Class<?> clazz, final String methodName) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws Exception {
                Method m = null;
                try {
                    m = clazz.getMethod(methodName, String.class);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (m == null) {
                    try {
                        m = clazz.getMethod(methodName, char[].class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return m;
            }
        });
    }
}

