/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.action.Executable;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;

public class BulkOperationCleanupAction
implements Executable,
Serializable {
    private final SessionImplementor session;
    private final Set affectedEntityNames = new HashSet();
    private final Set affectedCollectionRoles = new HashSet();
    private final Serializable[] spaces;

    public BulkOperationCleanupAction(SessionImplementor session, Queryable[] affectedQueryables) {
        int i;
        this.session = session;
        ArrayList<Serializable> tmpSpaces = new ArrayList<Serializable>();
        for (i = 0; i < affectedQueryables.length; ++i) {
            Set roles;
            if (affectedQueryables[i].hasCache()) {
                this.affectedEntityNames.add(affectedQueryables[i].getEntityName());
            }
            if ((roles = session.getFactory().getCollectionRolesByEntityParticipant(affectedQueryables[i].getEntityName())) != null) {
                this.affectedCollectionRoles.addAll(roles);
            }
            for (int y = 0; y < affectedQueryables[i].getQuerySpaces().length; ++y) {
                tmpSpaces.add(affectedQueryables[i].getQuerySpaces()[y]);
            }
        }
        this.spaces = new Serializable[tmpSpaces.size()];
        for (i = 0; i < tmpSpaces.size(); ++i) {
            this.spaces[i] = (Serializable)tmpSpaces.get(i);
        }
    }

    public BulkOperationCleanupAction(SessionImplementor session, Set querySpaces) {
        this.session = session;
        HashSet<Serializable> tmpSpaces = new HashSet<Serializable>(querySpaces);
        SessionFactoryImplementor factory = session.getFactory();
        for (Map.Entry entry : factory.getAllClassMetadata().entrySet()) {
            Set roles;
            String entityName = (String)entry.getKey();
            EntityPersister persister = factory.getEntityPersister(entityName);
            Serializable[] entitySpaces = persister.getQuerySpaces();
            if (!this.affectedEntity(querySpaces, entitySpaces)) continue;
            if (persister.hasCache()) {
                this.affectedEntityNames.add(persister.getEntityName());
            }
            if ((roles = session.getFactory().getCollectionRolesByEntityParticipant(persister.getEntityName())) != null) {
                this.affectedCollectionRoles.addAll(roles);
            }
            for (int y = 0; y < entitySpaces.length; ++y) {
                tmpSpaces.add(entitySpaces[y]);
            }
        }
        this.spaces = tmpSpaces.toArray(new Serializable[tmpSpaces.size()]);
    }

    private boolean affectedEntity(Set querySpaces, Serializable[] entitySpaces) {
        if (querySpaces == null || querySpaces.isEmpty()) {
            return true;
        }
        for (int i = 0; i < entitySpaces.length; ++i) {
            if (!querySpaces.contains(entitySpaces[i])) continue;
            return true;
        }
        return false;
    }

    public void init() {
        this.evictEntityRegions();
        this.evictCollectionRegions();
    }

    @Override
    public boolean hasAfterTransactionCompletion() {
        return true;
    }

    @Override
    public void afterTransactionCompletion(boolean success) throws HibernateException {
        this.evictEntityRegions();
        this.evictCollectionRegions();
    }

    @Override
    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    @Override
    public void beforeExecutions() throws HibernateException {
    }

    @Override
    public void execute() throws HibernateException {
    }

    private void evictEntityRegions() {
        if (this.affectedEntityNames != null) {
            for (String entityName : this.affectedEntityNames) {
                this.session.getFactory().evictEntity(entityName);
            }
        }
    }

    private void evictCollectionRegions() {
        if (this.affectedCollectionRoles != null) {
            for (String roleName : this.affectedCollectionRoles) {
                this.session.getFactory().evictCollection(roleName);
            }
        }
    }
}

