/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.util;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.bytecode.util.ClassFilter;

public class BasicClassFilter
implements ClassFilter {
    private final String[] includedPackages;
    private final Set includedClassNames = new HashSet();
    private final boolean isAllEmpty;

    public BasicClassFilter() {
        this(null, null);
    }

    public BasicClassFilter(String[] includedPackages, String[] includedClassNames) {
        this.includedPackages = includedPackages;
        if (includedClassNames != null) {
            for (int i = 0; i < includedClassNames.length; ++i) {
                this.includedClassNames.add(includedClassNames[i]);
            }
        }
        this.isAllEmpty = (this.includedPackages == null || this.includedPackages.length == 0) && this.includedClassNames.isEmpty();
    }

    @Override
    public boolean shouldInstrumentClass(String className) {
        if (this.isAllEmpty) {
            return true;
        }
        if (this.includedClassNames.contains(className)) {
            return true;
        }
        return this.isInIncludedPackage(className);
    }

    private boolean isInIncludedPackage(String className) {
        if (this.includedPackages != null) {
            for (int i = 0; i < this.includedPackages.length; ++i) {
                if (!className.startsWith(this.includedPackages[i])) continue;
                return true;
            }
        }
        return false;
    }
}

