/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.impl;

import java.util.Comparator;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.type.VersionType;

public class CacheDataDescriptionImpl
implements CacheDataDescription {
    private final boolean mutable;
    private final boolean versioned;
    private final Comparator versionComparator;

    public CacheDataDescriptionImpl(boolean mutable, boolean versioned, Comparator versionComparator) {
        this.mutable = mutable;
        this.versioned = versioned;
        this.versionComparator = versionComparator;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public boolean isVersioned() {
        return this.versioned;
    }

    @Override
    public Comparator getVersionComparator() {
        return this.versionComparator;
    }

    public static CacheDataDescriptionImpl decode(PersistentClass model) {
        return new CacheDataDescriptionImpl(model.isMutable(), model.isVersioned(), model.isVersioned() ? ((VersionType)model.getVersion().getType()).getComparator() : null);
    }

    public static CacheDataDescriptionImpl decode(Collection model) {
        return new CacheDataDescriptionImpl(model.isMutable(), model.getOwner().isVersioned(), model.getOwner().isVersioned() ? ((VersionType)model.getOwner().getVersion().getType()).getComparator() : null);
    }
}

