/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.jdbc.BlobImplementer;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.NonContextualLobCreator;
import org.hibernate.engine.jdbc.WrappedBlob;
import org.hibernate.type.AbstractType;
import org.hibernate.util.ArrayHelper;

public class BlobType
extends AbstractType {
    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SessionImplementor session) throws HibernateException, SQLException {
        if (settable[0]) {
            this.set(st, value, index, session);
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.set(st, value, index, session);
    }

    public void set(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        boolean useInputStream;
        if (value == null) {
            st.setNull(index, 2004);
            return;
        }
        Blob blob = (Blob)value;
        if (WrappedBlob.class.isInstance(blob)) {
            blob = ((WrappedBlob)value).getWrappedBlob();
        }
        boolean bl = useInputStream = session.getFactory().getDialect().useInputStreamToInsertBlob() && BlobImplementer.class.isInstance(blob);
        if (useInputStream) {
            st.setBinaryStream(index, blob.getBinaryStream(), (int)blob.length());
        } else {
            st.setBlob(index, blob);
        }
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.get(rs, name, Hibernate.getLobCreator(session));
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.get(rs, names[0], Hibernate.getLobCreator(session));
    }

    public Object get(ResultSet rs, String name) throws SQLException {
        return this.get(rs, name, NonContextualLobCreator.INSTANCE);
    }

    public Object get(ResultSet rs, String name, LobCreator lobCreator) throws SQLException {
        Blob value = rs.getBlob(name);
        return rs.wasNull() ? null : lobCreator.wrap(value);
    }

    @Override
    public Class getReturnedClass() {
        return Blob.class;
    }

    @Override
    public boolean isEqual(Object x, Object y, EntityMode entityMode) {
        return x == y;
    }

    @Override
    public int getHashCode(Object x, EntityMode entityMode) {
        return System.identityHashCode(x);
    }

    @Override
    public int compare(Object x, Object y, EntityMode entityMode) {
        return 0;
    }

    @Override
    public String getName() {
        return "blob";
    }

    @Override
    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Blobs are not cacheable");
    }

    @Override
    public Object deepCopy(Object value, EntityMode entityMode, SessionFactoryImplementor factory) {
        return value;
    }

    @Override
    public Object fromXMLNode(Node xml, Mapping factory) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public int getColumnSpan(Mapping mapping) {
        return 1;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        return target;
    }

    @Override
    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return new int[]{2004};
    }

    @Override
    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value == null ? "null" : value.toString();
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        return value == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        return checkable[0] && this.isDirty(old, current, session);
    }
}

