/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.bootstrap.spi.ServerConfig;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.JAXPDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
import org.jboss.system.deployers.SARArchiveFilter;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceDeploymentClassPath;
import org.jboss.system.metadata.ServiceDeploymentParser;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceMetaDataParser;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.xml.DOMWriter;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SARDeployer
extends JAXPDeployer<ServiceDeployment>
implements ManagedObjectCreator {
    private static final ManagedObjectFactory factory = ManagedObjectFactoryBuilder.create();

    public SARDeployer() {
        super(ServiceDeployment.class);
        this.setSuffix("-service.xml");
        this.setBuildManagedObject(true);
        this.setAllowMultipleFiles(true);
    }

    protected ServiceDeployment parse(VFSDeploymentUnit unit, VirtualFile file, Document document) throws Exception {
        List<ServiceMetaData> services;
        ServiceDeploymentParser parser = new ServiceDeploymentParser(document);
        ServiceDeployment parsed = parser.parse();
        String name = file.toURI().toString();
        parsed.setName(name);
        List<ServiceDeploymentClassPath> classPaths = parsed.getClassPaths();
        if (classPaths != null) {
            this.processXMLClasspath(unit, classPaths);
        }
        if ((services = parsed.getServices()) == null) {
            Element config = parsed.getConfig();
            if (config == null) {
                this.log.debug((Object)("Service deployment has no services: " + parsed.getName()));
                return parsed;
            }
            if (this.log.isDebugEnabled()) {
                String docStr = DOMWriter.printNode((Node)config, (boolean)true);
                int index = docStr.toLowerCase().indexOf("password");
                if (index != -1) {
                    docStr = this.maskPasswords(docStr, index);
                }
                this.log.debug((Object)docStr);
            }
            ServiceMetaDataParser SMDparser = new ServiceMetaDataParser(config);
            services = SMDparser.parse();
            parsed.setServices(services);
        }
        return parsed;
    }

    private void processXMLClasspath(VFSDeploymentUnit unit, List<ServiceDeploymentClassPath> classpaths) throws Exception {
        ArrayList<VirtualFile> classpath = new ArrayList<VirtualFile>();
        for (ServiceDeploymentClassPath path : classpaths) {
            String codebase = path.getCodeBase();
            String archives = path.getArchives();
            this.log.debug((Object)("Processing classpath: " + unit.getName() + " codebase=" + codebase + " archives=" + archives));
            VirtualFile codebaseFile = unit.getRoot();
            if (!".".equals(codebase)) {
                ServerConfig config = ServerConfigLocator.locate();
                URL codeBaseURL = new URL(config.getServerHomeURL(), codebase);
                codebaseFile = VFS.getRoot((URL)codeBaseURL);
            }
            if (codebaseFile == null) {
                throw new DeploymentException("Cannot use classpath without a root: " + unit.getName());
            }
            if (archives == null) {
                classpath.add(codebaseFile);
                this.log.debug((Object)("Using codebase as classpath: " + unit.getName()));
                continue;
            }
            SARArchiveFilter filter = new SARArchiveFilter(archives);
            List archiveFiles = codebaseFile.getChildren((VirtualFileFilter)filter);
            classpath.addAll(archiveFiles);
        }
        unit.prependClassPath(classpath);
    }

    private String maskPasswords(String original, int index) {
        StringBuilder sb = new StringBuilder(original);
        String modified = null;
        int startPasswdStringIndex = sb.indexOf(">", index);
        if (startPasswdStringIndex != -1) {
            int endPasswdStringIndex;
            if (sb.charAt(startPasswdStringIndex - 1) != '-' && (endPasswdStringIndex = sb.indexOf("<", startPasswdStringIndex)) != -1) {
                sb.replace(startPasswdStringIndex + 1, endPasswdStringIndex, "****");
            }
            if ((index = (modified = sb.toString()).toLowerCase().indexOf("password", startPasswdStringIndex)) != -1) {
                return this.maskPasswords(modified, index);
            }
            return modified;
        }
        return original;
    }

    public void build(DeploymentUnit unit, Set<String> attachmentNames, Map<String, ManagedObject> managedObjects) throws DeploymentException {
        for (Map.Entry entry : unit.getAttachments().entrySet()) {
            ManagedObject mo;
            String key = (String)entry.getKey();
            if (!ServiceDeployment.class.isInstance(entry.getValue()) || (mo = managedObjects.get(key)) != null || (mo = factory.initManagedObject(entry.getValue(), null, unit.getMetaData(), key, null)) == null) continue;
            if (mo instanceof ManagedObjectImpl) {
                ((ManagedObjectImpl)ManagedObjectImpl.class.cast(mo)).setAttachmentName(key);
            }
            managedObjects.put(key, mo);
        }
    }
}

