/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.PersonName;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class PersonNameHandler
extends AbstractHandler {
    public static final String TAG_NAME = "personName";

    protected PersonNameHandler(HandlerMaker maker) {
    }

    public RegistryObject unmarshal(Element element) {
        PersonName obj = new PersonName();
        obj.setValue(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        PersonName name = (PersonName)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        String nameValue = name.getValue();
        if (nameValue != null && nameValue.trim().length() > 0) {
            element.appendChild(parent.getOwnerDocument().createTextNode(nameValue));
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
    }
}

