/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.Unmodifiable;

public final class UnmodifiableOrderedMapIterator
implements OrderedMapIterator,
Unmodifiable {
    private OrderedMapIterator iterator;

    public static OrderedMapIterator decorate(OrderedMapIterator iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("OrderedMapIterator must not be null");
        }
        if (iterator instanceof Unmodifiable) {
            return iterator;
        }
        return new UnmodifiableOrderedMapIterator(iterator);
    }

    private UnmodifiableOrderedMapIterator(OrderedMapIterator iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Object next() {
        return this.iterator.next();
    }

    @Override
    public boolean hasPrevious() {
        return this.iterator.hasPrevious();
    }

    @Override
    public Object previous() {
        return this.iterator.previous();
    }

    @Override
    public Object getKey() {
        return this.iterator.getKey();
    }

    @Override
    public Object getValue() {
        return this.iterator.getValue();
    }

    @Override
    public Object setValue(Object value) {
        throw new UnsupportedOperationException("setValue() is not supported");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }
}

