/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.bpm;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.bpm.Actor;
import org.jboss.seam.bpm.ManagedJbpmContext;
import org.jboss.seam.web.Parameters;
import org.jbpm.taskmgmt.exe.TaskInstance;

@Name(value="org.jboss.seam.bpm.pooledTask")
@Scope(value=ScopeType.APPLICATION)
@Install(precedence=0, dependencies={"org.jboss.seam.bpm.jbpm"})
public class PooledTask {
    @Transactional
    public String assignToCurrentActor() {
        Actor actor = Actor.instance();
        if (actor.getId() == null) {
            throw new IllegalStateException("no current actor id defined");
        }
        TaskInstance taskInstance = this.getTaskInstance();
        if (taskInstance != null) {
            taskInstance.setActorId(actor.getId());
            return "taskAssignedToActor";
        }
        return null;
    }

    @Transactional
    public String assign(String actorId) {
        TaskInstance taskInstance = this.getTaskInstance();
        if (taskInstance != null) {
            taskInstance.setActorId(actorId);
            return "taskAssigned";
        }
        return null;
    }

    @Transactional
    public String unassign() {
        TaskInstance taskInstance = this.getTaskInstance();
        if (taskInstance != null) {
            taskInstance.setActorId(null);
            return "taskUnassigned";
        }
        return null;
    }

    @Transactional
    public TaskInstance getTaskInstance() {
        String[] values = Parameters.instance().getRequestParameters().get("taskId");
        if (values == null || values.length != 1) {
            return null;
        }
        String taskId = values[0];
        return taskId == null ? null : ManagedJbpmContext.instance().getTaskInstanceForUpdate(Long.parseLong(taskId));
    }
}

