/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.EntityBean;
import org.jboss.seam.contexts.EntityBeanList;
import org.jboss.seam.contexts.EntityBeanMap;
import org.jboss.seam.contexts.EntityBeanSet;
import org.jboss.seam.contexts.Wrapper;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Manager;
import org.jboss.seam.persistence.PersistenceContexts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConversationContext
implements Context {
    private final Map<String, Object> session;
    private final Map<String, Object> additions = new HashMap<String, Object>();
    private final Set<String> removals = new HashSet<String>();
    private final String id;
    private final List<String> idStack;

    private List<String> getIdStack() {
        return this.idStack == null ? Manager.instance().getCurrentConversationIdStack() : this.idStack;
    }

    private String getId() {
        return this.id == null ? Manager.instance().getCurrentConversationId() : this.id;
    }

    @Override
    public ScopeType getType() {
        return ScopeType.CONVERSATION;
    }

    private String getKey(String name) {
        return this.getPrefix(this.getId()) + name;
    }

    private String getKey(String name, String id) {
        return this.getPrefix(id) + name;
    }

    private String getPrefix(String id) {
        return ScopeType.CONVERSATION.getPrefix() + '#' + id + '$';
    }

    public ServerConversationContext(Map<String, Object> session) {
        this.session = session;
        this.id = null;
        this.idStack = null;
    }

    public ServerConversationContext(Map<String, Object> session, String id) {
        this.session = session;
        this.id = id;
        this.idStack = new LinkedList<String>();
        this.idStack.add(id);
    }

    @Override
    public Object get(String name) {
        Object result = this.additions.get(name);
        if (result != null) {
            return this.unwrapEntityBean(result);
        }
        if (this.removals.contains(name)) {
            return null;
        }
        List<String> stack = this.getIdStack();
        if (stack == null) {
            return this.unwrapEntityBean(this.session.get(this.getKey(name)));
        }
        for (int i = 0; i < stack.size(); ++i) {
            String id = stack.get(i);
            result = this.session.get(this.getKey(name, id));
            if (result != null) {
                return this.unwrapEntityBean(result);
            }
            if (i != 0 || !this.isPerNestedConversation(name)) continue;
            return null;
        }
        return null;
    }

    private boolean isPerNestedConversation(String name) {
        Component component = Component.forName(name);
        return component != null && component.isPerNestedConversation();
    }

    private Object unwrapEntityBean(Object result) {
        if (result == null) {
            return null;
        }
        if (result instanceof Wrapper) {
            return ((Wrapper)result).getInstance();
        }
        return result;
    }

    @Override
    public void set(String name, Object value) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preSetVariable." + name, new Object[0]);
        }
        if (value == null) {
            this.remove(name);
        } else {
            this.removals.remove(name);
            if (Seam.isEntityClass(value.getClass())) {
                value = new EntityBean(value);
            } else if (value instanceof List) {
                value = new EntityBeanList((List)value);
            } else if (value instanceof Map) {
                value = new EntityBeanMap((Map)value);
            } else if (value instanceof Set) {
                value = new EntityBeanSet((Set)value);
            }
            this.additions.put(name, value);
        }
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postSetVariable." + name, new Object[0]);
        }
    }

    @Override
    public boolean isSet(String name) {
        return this.get(name) != null;
    }

    @Override
    public void remove(String name) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preRemoveVariable." + name, new Object[0]);
        }
        this.additions.remove(name);
        this.removals.add(name);
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postRemoveVariable." + name, new Object[0]);
        }
    }

    @Override
    public String[] getNames() {
        Set<String> results = this.getNamesFromSession();
        results.addAll(this.additions.keySet());
        return results.toArray(new String[0]);
    }

    private Set<String> getNamesFromSession() {
        HashSet<String> results = new HashSet<String>();
        String prefix = this.getPrefix(this.getId());
        for (String name : this.session.keySet()) {
            if (!name.startsWith(prefix) || this.removals.contains(name = name.substring(prefix.length()))) continue;
            results.add(name);
        }
        return results;
    }

    private Set<String> getNamesForAllConversationsFromSession() {
        HashSet<String> results = new HashSet<String>();
        List<String> ids = Manager.instance().getCurrentConversationIdStack();
        if (ids != null) {
            for (String conversationId : ids) {
                String prefix = this.getPrefix(conversationId);
                for (String name : this.session.keySet()) {
                    String shortName;
                    if (!name.startsWith(prefix) || this.removals.contains(shortName = name.substring(prefix.length()))) continue;
                    results.add(name);
                }
            }
        }
        return results;
    }

    @Override
    public Object get(Class clazz) {
        return this.get(Component.getComponentName(clazz));
    }

    public void clear() {
        this.additions.clear();
        this.removals.addAll(this.getNamesFromSession());
    }

    public void unflush() {
        for (String key : this.getNamesForAllConversationsFromSession()) {
            Object attribute = this.session.get(key);
            if (attribute == null || !(attribute instanceof Wrapper)) continue;
            ((Wrapper)attribute).activate();
        }
    }

    @Override
    public void flush() {
        boolean longRunning;
        boolean bl = longRunning = !this.isCurrent() || Manager.instance().isLongRunningConversation();
        if (longRunning) {
            Object attribute;
            for (String string : this.getNamesForAllConversationsFromSession()) {
                attribute = this.session.get(string);
                if (attribute == null || !this.passivate(attribute) && !this.isAttributeDirty(attribute)) continue;
                this.session.put(string, attribute);
            }
            for (String string : this.removals) {
                this.session.remove(this.getKey(string));
            }
            this.removals.clear();
            PersistenceContexts.instance();
            for (Map.Entry entry : this.additions.entrySet()) {
                attribute = entry.getValue();
                this.passivate(attribute);
                this.session.put(this.getKey((String)entry.getKey()), attribute);
            }
            this.additions.clear();
        } else {
            for (String string : this.getNamesFromSession()) {
                this.session.remove(this.getKey(string));
            }
            for (String string : this.removals) {
                this.session.remove(this.getKey(string));
            }
            this.removals.clear();
        }
    }

    private boolean passivate(Object attribute) {
        if (attribute instanceof Wrapper) {
            return ((Wrapper)attribute).passivate();
        }
        return false;
    }

    private boolean isAttributeDirty(Object attribute) {
        return Contexts.isAttributeDirty(attribute);
    }

    private boolean isCurrent() {
        return this.id == null || this.id.equals(Manager.instance().getCurrentConversationId());
    }

    public String toString() {
        return "ConversationContext(" + this.getId() + ")";
    }
}

