/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.addressing;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.addressing.AddressingConstants;
import javax.xml.ws.addressing.AddressingException;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.AddressingType;
import javax.xml.ws.addressing.AttributedQName;
import javax.xml.ws.addressing.AttributedURI;
import javax.xml.ws.addressing.EndpointReference;
import javax.xml.ws.addressing.Relationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddressingBuilder
implements AddressingType {
    private static Logger log = Logger.getLogger(AddressingBuilder.class.getName());

    protected AddressingBuilder() {
    }

    public static AddressingBuilder getAddressingBuilder() {
        ClassLoader classLoader;
        try {
            classLoader = AddressingBuilder.getContextClassLoader();
        }
        catch (Exception x) {
            throw new AddressingException(x.toString(), x);
        }
        String name = null;
        try {
            name = AddressingBuilder.getSystemProperty("javax.xml.ws.addressing.AddressingBuilder");
            if (name != null) {
                return AddressingBuilder.newInstance(name, classLoader);
            }
        }
        catch (Exception e) {
            log.warning("Could not create and instance of " + name + " trying " + "org.jboss.ws.extensions.addressing.soap.SOAPAddressingBuilderImpl");
        }
        return AddressingBuilder.newInstance("org.jboss.ws.extensions.addressing.soap.SOAPAddressingBuilderImpl", classLoader);
    }

    private static AddressingBuilder newInstance(String className, ClassLoader classLoader) {
        try {
            Class<?> cls = classLoader == null ? Class.forName(className) : AddressingBuilder.loadClass(classLoader, className);
            return (AddressingBuilder)cls.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new AddressingException("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new AddressingException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    public abstract AttributedURI newURI(URI var1);

    public abstract AttributedURI newURI(String var1) throws URISyntaxException;

    public abstract AttributedQName newQName(QName var1);

    public abstract Relationship newRelationship(URI var1);

    public abstract EndpointReference newEndpointReference(URI var1);

    public abstract AddressingProperties newAddressingProperties();

    public abstract AddressingConstants newAddressingConstants();

    private static String getSystemProperty(final String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperty(name);
        }
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        };
        return AccessController.doPrivileged(action);
    }

    private static Class<?> loadClass(final ClassLoader cl, final String name) throws PrivilegedActionException, ClassNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return cl.loadClass(name);
        }
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException {
                try {
                    return cl.loadClass(name);
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
            }
        });
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

