/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.util;

import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;

public class ConfigurationPrinter {
    public static void prettyPrintConfiguration(Configuration configuration) {
        System.out.println("Configuration: " + configuration.getNotes());
        for (Property p : configuration.getProperties()) {
            ConfigurationPrinter.prettyPrintProperty(p, 1);
        }
    }

    private static void prettyPrintProperty(Property property, int indent) {
        if (property instanceof PropertyList) {
            for (int i = 0; i < indent; ++i) {
                System.out.print("\t");
            }
            System.out.println("List Property [" + property.getName() + "]");
            for (Property p : ((PropertyList)property).getList()) {
                ConfigurationPrinter.prettyPrintProperty(p, indent + 1);
            }
        } else if (property instanceof PropertyMap) {
            for (int i = 0; i < indent; ++i) {
                System.out.print("\t");
            }
            System.out.println("Map Property [" + property.getName() + "]");
            for (Property p : ((PropertyMap)property).getMap().values()) {
                ConfigurationPrinter.prettyPrintProperty(p, indent + 1);
            }
        } else if (property instanceof PropertySimple) {
            for (int i = 0; i < indent; ++i) {
                System.out.print("\t");
            }
            System.out.println(property.getName() + " = " + ((PropertySimple)property).getStringValue());
        }
    }
}

