/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.PreloaderService;
import org.apache.shindig.gadgets.render.ProxyRenderer;
import org.apache.shindig.gadgets.render.RenderingException;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.spec.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlRenderer {
    public static final String PATH_PARAM = "path";
    private final PreloaderService preloader;
    private final ProxyRenderer proxyRenderer;
    private final List<GadgetRewriter> gadgetRewriters;
    private final GadgetHtmlParser htmlParser;

    @Inject
    public HtmlRenderer(PreloaderService preloader, ProxyRenderer proxyRenderer, List<GadgetRewriter> gadgetRewriters, GadgetHtmlParser htmlParser) {
        this.preloader = preloader;
        this.proxyRenderer = proxyRenderer;
        this.gadgetRewriters = gadgetRewriters;
        this.htmlParser = htmlParser;
    }

    public String render(Gadget gadget) throws RenderingException {
        try {
            View view = gadget.getCurrentView();
            Collection<PreloadedData> preloads = this.preloader.preload(gadget);
            gadget.setPreloads(preloads);
            String content = view.getHref() == null ? view.getContent() : this.proxyRenderer.render(gadget);
            MutableContent mc = new MutableContent(this.htmlParser, content);
            for (GadgetRewriter rewriter : this.gadgetRewriters) {
                rewriter.rewrite(gadget, mc);
            }
            return mc.getContent();
        }
        catch (GadgetException e) {
            throw new RenderingException(e.getMessage(), e);
        }
        catch (RewritingException e) {
            throw new RenderingException(e.getMessage(), e);
        }
    }
}

