/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployers;

import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.endpoint.deployers.EJBIdentifier;
import org.jboss.ejb3.iiop.IORFactory;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IORDeployer
extends AbstractSimpleRealDeployer<JBossEnterpriseBeanMetaData> {
    private EJBIdentifier ejbIdentifier;

    public IORDeployer() {
        super(JBossEnterpriseBeanMetaData.class);
        this.setComponentsOnly(true);
        this.addOutput(BeanMetaData.class);
    }

    public void deploy(DeploymentUnit unit, JBossEnterpriseBeanMetaData bmd) throws DeploymentException {
        if (!(bmd instanceof JBossSessionBeanMetaData)) {
            return;
        }
        JBossSessionBeanMetaData sbmd = (JBossSessionBeanMetaData)bmd;
        String homeInterface = sbmd.getHome();
        if (homeInterface == null) {
            return;
        }
        String ejbName = sbmd.getEjbName();
        String ejbContainerBeanName = this.ejbIdentifier.identifyEJB(unit.getParent(), ejbName);
        String name = ejbContainerBeanName + "_IORFactory";
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)name, (String)IORFactory.class.getName());
        ValueMetaData value = builder.createInject((Object)ejbContainerBeanName);
        builder.addConstructorParameter(SessionContainer.class.getName(), value);
        unit.getParent().addAttachment(BeanMetaData.class.getName() + "." + name, (Object)builder.getBeanMetaData(), BeanMetaData.class);
    }

    @Inject
    public void setEJBIdentifier(EJBIdentifier ejbIdentifier) {
        this.ejbIdentifier = ejbIdentifier;
    }
}

