/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.pc.inventory.TimeoutException;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DAEMON_THREAD_POOL_NAME = "ResourceContainer.invoker.daemon";
    private static final String NON_DAEMON_THREAD_POOL_NAME = "ResourceContainer.invoker.nonDaemon";
    private static ExecutorService DAEMON_THREAD_POOL;
    private static ExecutorService NON_DAEMON_THREAD_POOL;
    private final Resource resource;
    private Availability availability;
    private SynchronizationState synchronizationState = SynchronizationState.NEW;
    private Set<MeasurementScheduleRequest> measurementSchedule = new HashSet<MeasurementScheduleRequest>();
    private Set<ResourcePackageDetails> installedPackages = new HashSet<ResourcePackageDetails>();
    private transient ResourceComponent resourceComponent;
    private transient ResourceContext resourceContext;
    private transient ResourceComponentState resourceComponentState = ResourceComponentState.STOPPED;
    private transient ReentrantReadWriteLock facetAccessLock = new ReentrantReadWriteLock();
    private transient Map<Integer, Object> proxyCache = new HashMap<Integer, Object>();
    private transient ClassLoader resourceClassLoader;

    public static void initialize() {
        LoggingThreadFactory daemonFactory = new LoggingThreadFactory(DAEMON_THREAD_POOL_NAME, true);
        LoggingThreadFactory nonDaemonFactory = new LoggingThreadFactory(NON_DAEMON_THREAD_POOL_NAME, false);
        DAEMON_THREAD_POOL = Executors.newCachedThreadPool(daemonFactory);
        NON_DAEMON_THREAD_POOL = Executors.newCachedThreadPool(nonDaemonFactory);
    }

    public static void shutdown() {
        DAEMON_THREAD_POOL.shutdown();
        NON_DAEMON_THREAD_POOL.shutdown();
    }

    public ResourceContainer(Resource resource, ClassLoader resourceClassLoader) {
        this.resource = resource;
        this.resourceClassLoader = resourceClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Availability updateAvailability(AvailabilityType availabilityType) {
        Date now = new Date();
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.availability = new Availability(this.resource, now, availabilityType);
            return this.availability;
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Availability getAvailability() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            return this.availability;
        }
    }

    public Lock getReadFacetLock() {
        return this.facetAccessLock.readLock();
    }

    public Lock getWriteFacetLock() {
        return this.facetAccessLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResourcePackageDetails> getInstalledPackages() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            return this.installedPackages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstalledPackages(Set<ResourcePackageDetails> installedPackages) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.installedPackages = installedPackages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceComponent getResourceComponent() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            return this.resourceComponent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceComponent(ResourceComponent resourceComponent) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.resourceComponent = resourceComponent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceContext getResourceContext() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            return this.resourceContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceContext(ResourceContext resourceContext) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.resourceContext = resourceContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MeasurementScheduleRequest> getMeasurementSchedule() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            return this.measurementSchedule;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMeasurementSchedule(Set<MeasurementScheduleRequest> measurementSchedule) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.measurementSchedule = measurementSchedule;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateMeasurementSchedule(Set<MeasurementScheduleRequest> measurementScheduleUpdate) {
        HashSet<Integer> updateScheduleIds = new HashSet<Integer>();
        for (MeasurementScheduleRequest update : measurementScheduleUpdate) {
            updateScheduleIds.add(update.getScheduleId());
        }
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            HashSet<MeasurementScheduleRequest> toBeRemoved = new HashSet<MeasurementScheduleRequest>();
            for (MeasurementScheduleRequest current : this.measurementSchedule) {
                if (!updateScheduleIds.contains(current.getScheduleId())) continue;
                toBeRemoved.add(current);
            }
            this.measurementSchedule.removeAll(toBeRemoved);
            return this.measurementSchedule.addAll(measurementScheduleUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceComponentState getResourceComponentState() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            return this.resourceComponentState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceComponentState(ResourceComponentState state) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.resourceComponentState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizationState getSynchronizationState() {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            return this.synchronizationState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizationState(SynchronizationState synchronizationState) {
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            this.synchronizationState = synchronizationState;
        }
    }

    public ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    public void setResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourceClassLoader = resourceClassLoader;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[resource=" + this.resource + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T createResourceComponentProxy(Class<T> facetInterface, FacetLockType lockType, long timeout, boolean daemonThread, boolean onlyIfStarted) throws PluginContainerException {
        if (onlyIfStarted && !ResourceComponentState.STARTED.equals((Object)this.getResourceComponentState())) {
            throw new PluginContainerException("Resource component could not be retrieved for resource [" + this.getResource() + "] because the component is not started. Its state is [" + (Object)((Object)this.getResourceComponentState()) + "]");
        }
        ResourceComponent resourceComponent = this.getResourceComponent();
        if (resourceComponent == null) {
            throw new PluginContainerException("Component does not exist for resource: " + this.getResource());
        }
        if (!facetInterface.isAssignableFrom(resourceComponent.getClass())) {
            throw new PluginContainerException("Component does not support the [" + facetInterface.getName() + "] interface: " + this);
        }
        if (lockType == FacetLockType.NONE && timeout == 0L) {
            return (T)resourceComponent;
        }
        int key = facetInterface.hashCode();
        key = 31 * key + lockType.hashCode();
        key = 31 * key + (int)(timeout ^ timeout >>> 32);
        key = 31 * key + (daemonThread ? 1 : 0);
        ResourceContainer resourceContainer = this;
        synchronized (resourceContainer) {
            Object proxy;
            if (this.proxyCache == null) {
                this.proxyCache = new HashMap<Integer, Object>();
            }
            if ((proxy = this.proxyCache.get(key)) == null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                ResourceComponentInvocationHandler handler = new ResourceComponentInvocationHandler(this, lockType, timeout, daemonThread, facetInterface);
                proxy = Proxy.newProxyInstance(classLoader, new Class[]{facetInterface}, (InvocationHandler)handler);
                this.proxyCache.put(key, proxy);
            }
            return (T)proxy;
        }
    }

    private String getFacetLockStatus() {
        StringBuilder str = new StringBuilder("Facet lock status for [" + this.getResource());
        str.append("], is-write-locked=[").append(this.facetAccessLock.isWriteLocked());
        str.append("], is-write-locked-by-current-thread=[").append(this.facetAccessLock.isWriteLockedByCurrentThread());
        str.append("], read-locks=[").append(this.facetAccessLock.getReadLockCount());
        str.append("], waiting-for-lock-queue-size=[").append(this.facetAccessLock.getQueueLength());
        str.append("]");
        return str.toString();
    }

    private Object readResolve() throws ObjectStreamException {
        this.facetAccessLock = new ReentrantReadWriteLock();
        return this;
    }

    private static class ComponentInvocationThread
    implements Callable {
        private final ResourceContainer resourceContainer;
        private final Method method;
        private final Object[] args;
        private final Lock lock;

        ComponentInvocationThread(ResourceContainer resourceContainer, Method method, Object[] args, Lock lock) {
            this.resourceContainer = resourceContainer;
            this.method = method;
            this.args = args;
            this.lock = lock;
        }

        public Object call() throws Exception {
            ResourceComponent resourceComponent = this.resourceContainer.getResourceComponent();
            if (this.lock != null) {
                try {
                    this.lock.lockInterruptibly();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Object results;
                ClassLoader pluginClassLoader = this.resourceContainer.getResourceClassLoader();
                if (pluginClassLoader == null) {
                    throw new IllegalStateException("No plugin class loader was specified for " + this + ".");
                }
                Thread.currentThread().setContextClassLoader(pluginClassLoader);
                Object object = results = this.method.invoke((Object)resourceComponent, this.args);
                return object;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw cause instanceof Exception ? (Exception)cause : new Exception(cause);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (this.lock != null) {
                    this.lock.unlock();
                }
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
    }

    private static class ResourceComponentInvocationHandler
    implements InvocationHandler {
        private static final Log LOG = LogFactory.getLog(ResourceComponentInvocationHandler.class);
        private final ResourceContainer container;
        private final Lock lock;
        private final long timeout;
        private final boolean daemonThread;
        private final Class facetInterface;

        public ResourceComponentInvocationHandler(ResourceContainer container, FacetLockType lockType, long timeout, boolean daemonThread, Class facetInterface) {
            this.container = container;
            switch (lockType) {
                case WRITE: {
                    this.lock = container.getWriteFacetLock();
                    break;
                }
                case READ: {
                    this.lock = container.getReadFacetLock();
                    break;
                }
                default: {
                    this.lock = null;
                }
            }
            if (timeout <= 0L) {
                throw new IllegalArgumentException("timeout value is not positive.");
            }
            this.timeout = timeout;
            this.daemonThread = daemonThread;
            this.facetInterface = facetInterface;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().equals(this.facetInterface)) {
                return this.invokeInNewThreadWithLock(method, args);
            }
            return this.invokeInCurrentThreadWithoutLock(method, args);
        }

        private Object invokeInNewThreadWithLock(Method method, Object[] args) throws Throwable {
            ExecutorService threadPool = this.daemonThread ? DAEMON_THREAD_POOL : NON_DAEMON_THREAD_POOL;
            ComponentInvocationThread invocationThread = new ComponentInvocationThread(this.container, method, args, this.lock);
            Future future = threadPool.submit(invocationThread);
            try {
                return future.get(this.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Thread [" + Thread.currentThread().getName() + "] was interrupted."));
                if (this.daemonThread) {
                    future.cancel(true);
                }
                throw new RuntimeException(this.invokedMethodString(method, args, "was rudely interrupted."), e);
            }
            catch (ExecutionException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.invokedMethodString(method, args, "failed."), (Throwable)e);
                }
                throw e.getCause();
            }
            catch (java.util.concurrent.TimeoutException e) {
                String msg = this.invokedMethodString(method, args, "timed out. Invocation thread will be interrupted");
                LOG.debug((Object)msg);
                future.cancel(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)this.container.getFacetLockStatus());
                }
                throw new TimeoutException(msg);
            }
        }

        private String invokedMethodString(Method method, Object[] methodArgs, String extraMsg) {
            String name = this.container.getResourceComponent().getClass().getName() + '.' + method.getName() + "()";
            String args = methodArgs != null ? Arrays.asList(methodArgs).toString() : "";
            return "Call to [" + name + "] with args [" + args + "] " + extraMsg;
        }

        private Object invokeInCurrentThreadWithoutLock(Method method, Object[] args) throws Throwable {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader pluginClassLoader = this.container.getResourceClassLoader();
                if (pluginClassLoader == null) {
                    throw new IllegalStateException("No plugin classloader was specified for " + this + ".");
                }
                Thread.currentThread().setContextClassLoader(pluginClassLoader);
                Object object = method.invoke((Object)this.container.getResourceComponent(), args);
                return object;
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause() != null ? ite.getCause() : ite;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResourceComponentState {
        STARTED,
        STOPPED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SynchronizationState {
        NEW,
        SYNCHRONIZED,
        DELETED_ON_AGENT,
        DELETED_ON_SERVER;

    }
}

