/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.domain;

import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.InterceptionMarkers;
import org.jboss.aop.advice.AspectDefinition;

public abstract class ScopedClassLoaderDomain
extends Domain {
    private WeakReference<ClassLoader> loader;
    protected boolean parentDelegation;
    protected ConcurrentHashMap<String, Object> myPerVMAspects = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Boolean> notMyPerVMAspects = new ConcurrentHashMap();
    protected InterceptionMarkers interceptionMarkers = new InterceptionMarkers();
    protected String classLoaderString;

    public ScopedClassLoaderDomain(ClassLoader loader, String name, boolean parentDelegation, AspectManager manager, boolean parentFirst) {
        super(manager, name, parentFirst);
        if (loader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        this.loader = new WeakReference<ClassLoader>(loader);
        this.parentDelegation = parentDelegation;
        this.classLoaderString = loader.toString();
        this.inheritsBindings = true;
        this.inheritsDeclarations = true;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader cl = (ClassLoader)this.loader.get();
        if (cl != null) {
            return cl;
        }
        return null;
    }

    public abstract boolean isValid();

    public void removeAspectDefinition(String name) {
        AspectDefinition def = super.internalRemoveAspectDefintion(name);
        if (def != null) {
            this.myPerVMAspects.remove(name);
        }
    }

    public Object getPerVMAspect(AspectDefinition def) {
        return this.getPerVMAspect(def.getName());
    }

    public Object getPerVMAspect(String def) {
        if (this.parentDelegation) {
            Object aspect = super.getPerVMAspect(def);
            return aspect;
        }
        return this.getPerVmAspectWithNoParentDelegation(def);
    }

    protected Object createPerVmAspect(String def, AspectDefinition adef, ClassLoader scopedClassLoader) {
        return super.createPerVmAspect(def, adef, this.getClassLoader());
    }

    protected Object getSuperPerVmAspect(String def) {
        return super.getPerVMAspect(def);
    }

    protected abstract Object getPerVmAspectWithNoParentDelegation(String var1);
}

