/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.common.lang;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.ejb3.common.classloader.util.PrimitiveClassLoadingUtil;
import org.jboss.ejb3.common.lang.SecurityActions;
import org.jboss.logging.Logger;

public class SerializableMethod
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(SerializableMethod.class);
    private String name;
    private String declaringClassName;
    private String actualClassName;
    private String returnType;
    private String[] argumentTypes;

    public SerializableMethod(Method method) {
        this(method, method.getDeclaringClass());
    }

    public SerializableMethod(Method method, Class<?> actualClass) {
        this(method, actualClass != null ? actualClass.getName() : null);
    }

    public SerializableMethod(Method method, String actualClassName) {
        this.setName(method.getName());
        this.setDeclaringClassName(method.getDeclaringClass().getName());
        this.setActualClassName(actualClassName);
        this.setReturnType(method.getReturnType().getName());
        Class<?>[] paramTypes = method.getParameterTypes();
        ArrayList<String> paramTypesString = new ArrayList<String>();
        if (paramTypes != null) {
            for (Class<?> paramType : paramTypes) {
                paramTypesString.add(paramType.getName());
            }
        }
        this.setArgumentTypes(paramTypesString.toArray(new String[0]));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SerializableMethod)) {
            return false;
        }
        SerializableMethod other = (SerializableMethod)SerializableMethod.class.cast(obj);
        return this.getDeclaringClassName().equals(other.getDeclaringClassName()) && this.getName().equals(other.getName()) && Arrays.equals(this.getArgumentTypes(), other.getArgumentTypes()) && this.getActualClassName().equals(other.getActualClassName());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getActualClassName());
        sb.append(": ");
        sb.append(this.getDeclaringClassName());
        sb.append('.');
        sb.append(this.getName());
        sb.append('(');
        int count = 0;
        for (String argType : this.getArgumentTypes()) {
            sb.append(argType);
            if (++count >= this.getArgumentTypes().length) continue;
            sb.append(',');
        }
        sb.append(')');
        return sb.toString();
    }

    public Method toMethod() {
        return this.toMethod(SecurityActions.getThreadContextClassLoader());
    }

    public Method toMethod(ClassLoader cl) {
        Class<?> invokingClass = this.getClassType(cl);
        ArrayList argTypesList = new ArrayList();
        for (String argTypeName : this.getArgumentTypes()) {
            Class<?> argType = this.getClassFromName(argTypeName, cl);
            argTypesList.add(argType);
        }
        Class[] argTypes = argTypesList.toArray(new Class[0]);
        String methodName = this.getName();
        Method invokedMethod = null;
        try {
            invokedMethod = invokingClass.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("Method " + this + " does not exist in " + invokingClass.getName(), nsme);
        }
        return invokedMethod;
    }

    public Class<?> getClassType() {
        return this.getClassType(Thread.currentThread().getContextClassLoader());
    }

    public Class<?> getClassType(ClassLoader cl) {
        Class<?> clazz = this.getClassFromName(this.getDeclaringClassName(), cl);
        return clazz;
    }

    protected Class<?> getClassFromName(String name, ClassLoader cl) {
        assert (cl != null) : ClassLoader.class.getSimpleName() + " must be defined.";
        Class<?> clazz = null;
        try {
            clazz = PrimitiveClassLoadingUtil.loadClass(name, cl);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Specified calling class, " + name + " could not be found for " + cl, cnfe);
        }
        return clazz;
    }

    public String getDeclaringClassName() {
        return this.declaringClassName;
    }

    public void setDeclaringClassName(String className) {
        this.declaringClassName = className;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public void setArgumentTypes(String[] argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getActualClassName() {
        return this.actualClassName;
    }

    public void setActualClassName(String actualClassName) {
        if (actualClassName == null || actualClassName.trim().length() == 0) {
            String declaringClassName = this.getDeclaringClassName();
            assert (declaringClassName != null && declaringClassName.trim().length() > 0) : "Cannot implicitly set actual class to declaring class as declaring class is not defined";
            actualClassName = declaringClassName;
            log.debug((Object)("Actual class name has not been explicitly specified, so defaulting to declaring class name: " + declaringClassName));
        }
        this.actualClassName = actualClassName;
    }
}

