/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeExistsException;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeRepository;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.UpdateNodeTypeObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeTypeRepository
implements NodeTypeRepository {
    protected final NodeTypeDataPersister nodeTypeDataPersister;

    public AbstractNodeTypeRepository(NodeTypeDataPersister nodeTypeDataPersister) {
        this.nodeTypeDataPersister = nodeTypeDataPersister;
    }

    @Override
    public List<NodeTypeData> getAllNodeTypes() throws RepositoryException {
        return this.nodeTypeDataPersister.getAllNodeTypes();
    }

    @Override
    public boolean isStorageFilled() {
        return this.nodeTypeDataPersister.isStorageFilled();
    }

    @Override
    public void registerNodeType(List<NodeTypeData> nodeTypes, final NodeTypeDataManager nodeTypeDataManager, final String accessControlPolicy, final int alreadyExistsBehaviour) throws RepositoryException {
        final HashMap<InternalQName, NodeTypeData> volatileNodeTypes = new HashMap<InternalQName, NodeTypeData>();
        for (NodeTypeData nodeTypeData : nodeTypes) {
            volatileNodeTypes.put(nodeTypeData.getName(), nodeTypeData);
        }
        final ArrayList wait4RegistrationNodeTypes = new ArrayList();
        if (this.nodeTypeDataPersister != null) {
            this.nodeTypeDataPersister.update(nodeTypes, new UpdateNodeTypeObserver(){

                public void afterUpdate(NodeTypeData updatetNodetype, Object context) {
                }

                public void beforeUpdate(NodeTypeData updatetNodetype, Object context) throws RepositoryException {
                    if (updatetNodetype == null) {
                        throw new RepositoryException("NodeTypeData object " + updatetNodetype + " is null");
                    }
                    if (accessControlPolicy.equals("disable") && updatetNodetype.getName().equals("exo:privilegeable")) {
                        throw new RepositoryException("NodeType exo:privilegeable is DISABLED");
                    }
                    InternalQName qname = updatetNodetype.getName();
                    if (qname == null) {
                        throw new RepositoryException("NodeType implementation class " + updatetNodetype.getClass().getName() + " is not supported in this method");
                    }
                    NodeTypeData registeredNodeType = AbstractNodeTypeRepository.this.getNodeType(qname);
                    if (registeredNodeType != null) {
                        switch (alreadyExistsBehaviour) {
                            case 2: {
                                throw new NodeTypeExistsException("NodeType " + (Object)((Object)updatetNodetype.getName()) + " is already registered");
                            }
                            case 4: {
                                ((PlainChangesLog)context).addAll(nodeTypeDataManager.updateNodeType(registeredNodeType, updatetNodetype, volatileNodeTypes).getAllStates());
                            }
                        }
                    } else {
                        wait4RegistrationNodeTypes.add(updatetNodetype);
                    }
                }

                public boolean shouldSkip(NodeTypeData updatetNodetype, Object context) throws RepositoryException {
                    NodeTypeData registeredNodeType = AbstractNodeTypeRepository.this.getNodeType(updatetNodetype.getName());
                    return registeredNodeType != null && alreadyExistsBehaviour == 0;
                }
            });
        }
        for (NodeTypeData nodeTypeData : wait4RegistrationNodeTypes) {
            this.addNodeType(nodeTypeData, volatileNodeTypes);
        }
    }

    public void start() {
    }

    public void stop() {
    }
}

