/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invalidation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.cache.invalidation.BatchInvalidation;
import org.jboss.cache.invalidation.InvalidationGroup;
import org.jboss.cache.invalidation.InvalidationManagerMBean;
import org.jboss.cache.invalidation.InvalidationsTxGrouper;

class InvalidatorSynchronization
implements Synchronization {
    protected Transaction tx;
    protected HashMap ids = new HashMap();

    InvalidatorSynchronization(Transaction tx) {
        this.tx = tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvalidation(InvalidationGroup group, Serializable key) {
        HashSet<Serializable> relatedInvalidations;
        HashMap relatedInvalidationMgr;
        InvalidationManagerMBean im = group.getInvalidationManager();
        HashMap hashMap = this.ids;
        synchronized (hashMap) {
            relatedInvalidationMgr = (HashMap)this.ids.get(im);
            if (relatedInvalidationMgr == null) {
                relatedInvalidationMgr = new HashMap();
                this.ids.put(im, relatedInvalidationMgr);
            }
        }
        HashMap hashMap2 = relatedInvalidationMgr;
        synchronized (hashMap2) {
            relatedInvalidations = (HashSet<Serializable>)relatedInvalidationMgr.get(group);
            if (relatedInvalidations == null) {
                relatedInvalidations = new HashSet<Serializable>();
                relatedInvalidationMgr.put(group, relatedInvalidations);
            }
        }
        relatedInvalidations.add(key);
    }

    public void beforeCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int status) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                this.sendBatchInvalidations();
            }
            catch (Exception ex) {
                InvalidationsTxGrouper.log.warn((Object)"Failed sending invalidations messages", (Throwable)ex);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    protected void sendBatchInvalidations() {
        boolean trace = InvalidationsTxGrouper.log.isTraceEnabled();
        if (trace) {
            InvalidationsTxGrouper.log.trace((Object)("Begin sendBatchInvalidations, tx=" + this.tx));
        }
        for (InvalidationManagerMBean im : this.ids.keySet()) {
            HashMap relatedInvalidationMgr = (HashMap)this.ids.get(im);
            BatchInvalidation[] bomb = new BatchInvalidation[relatedInvalidationMgr.size()];
            Iterator groupsIter = relatedInvalidationMgr.keySet().iterator();
            int i = 0;
            while (groupsIter.hasNext()) {
                BatchInvalidation batch;
                InvalidationGroup group = (InvalidationGroup)groupsIter.next();
                HashSet sourceIds = (HashSet)relatedInvalidationMgr.get(group);
                String groupName = group.getGroupName();
                if (trace) {
                    InvalidationsTxGrouper.log.trace((Object)("Adding ids to bomb(" + groupName + "): " + sourceIds));
                }
                Serializable[] ids = new Serializable[sourceIds.size()];
                sourceIds.toArray(ids);
                bomb[i] = batch = new BatchInvalidation(ids, groupName);
                ++i;
            }
            im.batchInvalidate(bomb);
        }
        if (trace) {
            InvalidationsTxGrouper.log.trace((Object)("End sendBatchInvalidations, tx=" + this.tx));
        }
        this.ids = null;
    }
}

