/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.SchemaResolverDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.client.spec.ApplicationClientMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.ModulesMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppParsingDeployer
extends SchemaResolverDeployer<EarMetaData> {
    public AppParsingDeployer() {
        super(EarMetaData.class);
        this.setName("application.xml");
    }

    public String getAppXmlPath() {
        return this.getName();
    }

    public void setAppXmlPath(String appXmlPath) {
        this.setName(appXmlPath);
    }

    protected EarMetaData parse(VFSDeploymentUnit unit, VirtualFile file, EarMetaData root) throws Exception {
        EarMetaData ear = (EarMetaData)super.parse(unit, file, (Object)root);
        List children = unit.getChildren();
        ModulesMetaData modules = ear.getModules();
        if (children != null && modules != null) {
            for (DeploymentUnit child : children) {
                String attachmentName;
                String moduleName = child.getSimpleName();
                ModuleMetaData module = (ModuleMetaData)modules.get(moduleName);
                if (module == null || module.getAlternativeDD() == null) continue;
                VirtualFile altDDFile = unit.getRoot().getChild(module.getAlternativeDD());
                if (altDDFile == null) {
                    throw new IllegalStateException("Failed to locate alternative DD '" + module.getAlternativeDD() + "' in " + unit.getRoot().getPathName());
                }
                if (module.getType() == ModuleMetaData.ModuleType.Ejb) {
                    attachmentName = EjbJarMetaData.class.getName();
                } else if (module.getType() == ModuleMetaData.ModuleType.Web) {
                    attachmentName = WebMetaData.class.getName();
                } else if (module.getType() == ModuleMetaData.ModuleType.Client) {
                    attachmentName = ApplicationClientMetaData.class.getName();
                } else if (module.getType() == ModuleMetaData.ModuleType.Connector) {
                    attachmentName = "org.jboss.resource.metadata.ConnectorMetaData";
                } else {
                    throw new IllegalStateException("Expected module types in an EAR are ejb, web, java and connector but got " + module.getType() + " for " + child.getName() + " in " + unit.getName());
                }
                child.addAttachment(attachmentName + ".altDD", (Object)altDDFile);
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("attached alt-dd " + altDDFile + " for module " + child.getSimpleName()));
            }
        }
        return ear;
    }
}

