/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.dependency;

import java.util.Iterator;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployment.dependency.JndiDependencyItem;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiDependencyMetaData
extends JBossObject
implements DependencyMetaData {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(JndiDependencyMetaData.class);
    private String jndiName;
    private Object demand;
    private ClassLoader loader;
    private ControllerState whenRequired = ControllerState.INSTALLED;

    public JndiDependencyMetaData(String jndiName, ClassLoader loader) {
        this(jndiName, loader, ControllerState.INSTALLED);
    }

    public JndiDependencyMetaData(String jndiName, ClassLoader loader, ControllerState whenRequired) {
        this.jndiName = jndiName;
        this.loader = loader;
        this.whenRequired = whenRequired;
    }

    public Object getDependency() {
        return this.demand;
    }

    public ControllerState getWhenRequired() {
        return this.whenRequired;
    }

    public void describeVisit(MetaDataVisitor vistor) {
        vistor.describeVisit((MetaDataVisitorNode)this);
    }

    public Iterator<? extends MetaDataVisitorNode> getChildren() {
        return null;
    }

    public void initialVisit(MetaDataVisitor visitor) {
        KernelControllerContext context = visitor.getControllerContext();
        JndiDependencyItem item = new JndiDependencyItem(this.jndiName, this.loader, this.whenRequired);
        visitor.addDependency((DependencyItem)item);
        visitor.initialVisit((MetaDataVisitorNode)this);
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append(this.jndiName);
    }

    public String toShortString() {
        JBossStringBuilder buffer = new JBossStringBuilder();
        this.toShortString(buffer);
        return buffer.toString();
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.jndiName);
    }
}

