/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.ejb.txtimer.TimedObjectId;
import org.jboss.ejb.txtimer.TimerHandleImpl;
import org.jboss.ejb.txtimer.UpdateableDatabasePersistencePlugin;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.logging.Logger;
import org.jboss.mx.util.ObjectNameFactory;

public class GeneralPurposeDatabasePersistencePlugin
implements UpdateableDatabasePersistencePlugin {
    private static Logger log = Logger.getLogger(GeneralPurposeDatabasePersistencePlugin.class);
    protected MBeanServer server;
    protected ObjectName dataSourceName;
    protected String tableName;
    protected DataSource ds;
    protected ObjectName metaDataName;
    private int binarySqlType;

    public void init(MBeanServer server, ObjectName dataSource, String tableName) throws SQLException {
        if (tableName == null) {
            throw new IllegalArgumentException("Timers tableName is null");
        }
        if (tableName.length() == 0) {
            throw new IllegalArgumentException("Timers tableName is empty");
        }
        this.tableName = tableName;
        this.init(server, dataSource);
    }

    public void init(MBeanServer server, ObjectName dataSourceName) throws SQLException {
        this.server = server;
        this.dataSourceName = dataSourceName;
        try {
            String dsJndiTx = (String)server.getAttribute(dataSourceName, "BindName");
            this.ds = (DataSource)new InitialContext().lookup(dsJndiTx);
        }
        catch (Exception e) {
            throw new SQLException("Failed to lookup data source: " + dataSourceName);
        }
        String dsName = dataSourceName.getKeyProperty("name");
        this.metaDataName = ObjectNameFactory.create((String)("jboss.jdbc:datasource=" + dsName + ",service=metadata"));
        if (!this.server.isRegistered(this.metaDataName)) {
            throw new IllegalStateException("Cannot find datasource meta data: " + this.metaDataName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createTableIfNotExists() throws SQLException {
        Connection con = null;
        Statement st = null;
        try {
            block7: {
                try {
                    JDBCTypeMappingMetaData typeMapping = (JDBCTypeMappingMetaData)this.server.getAttribute(this.metaDataName, "TypeMappingMetaData");
                    if (typeMapping == null) {
                        throw new IllegalStateException("Cannot obtain type mapping from: " + this.metaDataName);
                    }
                    JDBCMappingMetaData objectMetaData = typeMapping.getTypeMappingMetaData(Object.class);
                    this.binarySqlType = objectMetaData.getJdbcType();
                    if (!SQLUtil.tableExists(this.getTableName(), this.ds)) {
                        con = this.ds.getConnection();
                        String dateType = typeMapping.getTypeMappingMetaData(Timestamp.class).getSqlType();
                        String longType = typeMapping.getTypeMappingMetaData(Long.class).getSqlType();
                        String objectType = objectMetaData.getSqlType();
                        StringBuffer createTableDDL = new StringBuffer("create table " + this.getTableName() + " (" + " " + this.getColumnTimerID() + " varchar(80) not null," + " " + this.getColumnTargetID() + " varchar(250) not null," + " " + this.getColumnInitialDate() + " " + dateType + " not null," + " " + this.getColumnNextDate() + " " + dateType + "," + " " + this.getColumnTimerInterval() + " " + longType + "," + " " + this.getColumnInstancePK() + " " + objectType + "," + " " + this.getColumnInfo() + " " + objectType + ", ");
                        JDBCFunctionMappingMetaData pkConstraint = typeMapping.getPkConstraintTemplate();
                        String name = SQLUtil.unquote(this.getTableName(), this.ds) + "_PK";
                        name = SQLUtil.fixConstraintName(name, this.ds);
                        Object[] templateParams = new String[]{name, this.getColumnTimerID() + ", " + this.getColumnTargetID()};
                        pkConstraint.getFunctionSql(templateParams, createTableDDL);
                        createTableDDL.append(" )");
                        log.debug((Object)("Executing DDL: " + createTableDDL));
                        st = con.createStatement();
                        st.executeUpdate(createTableDDL.toString());
                        break block7;
                    }
                    if (this.isNextDateColumnPresent()) break block7;
                    con = this.ds.getConnection();
                    String dateType = typeMapping.getTypeMappingMetaData(Timestamp.class).getSqlType();
                    StringBuffer alterTableDDL = new StringBuffer("alter table " + this.getTableName() + " ADD " + " " + this.getColumnNextDate() + " " + dateType);
                    log.debug((Object)("Adding new column " + this.getColumnNextDate() + " to table " + this.getTableName() + " - executing DDL: " + alterTableDDL));
                    st = con.createStatement();
                    st.executeUpdate(alterTableDDL.toString());
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error((Object)"Cannot create timer table", (Throwable)e);
                    Object var13_17 = null;
                    JDBCUtil.safeClose(st);
                    JDBCUtil.safeClose(con);
                    return;
                }
            }
            Object var13_16 = null;
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            return;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTimer(String timerId, TimedObjectId timedObjectId, Date initialExpiration, long intervalDuration, Serializable info) throws SQLException {
        Connection con = null;
        PreparedStatement st = null;
        try {
            con = this.ds.getConnection();
            String sql = "insert into " + this.getTableName() + " " + "(" + this.getColumnTimerID() + "," + this.getColumnTargetID() + "," + this.getColumnInitialDate() + "," + this.getColumnTimerInterval() + "," + this.getColumnInstancePK() + "," + this.getColumnInfo() + "," + this.getColumnNextDate() + ") " + "values (?,?,?,?,?,?,?)";
            st = con.prepareStatement(sql);
            st.setString(1, timerId);
            st.setString(2, timedObjectId.toString());
            st.setTimestamp(3, new Timestamp(initialExpiration.getTime()));
            st.setLong(4, intervalDuration);
            byte[] bytes = this.serialize(timedObjectId.getInstancePk());
            if (bytes == null) {
                st.setNull(5, this.binarySqlType);
            } else {
                st.setBytes(5, bytes);
            }
            bytes = this.serialize(info);
            if (bytes == null) {
                st.setNull(6, this.binarySqlType);
            } else {
                st.setBytes(6, bytes);
            }
            st.setTimestamp(7, new Timestamp(initialExpiration.getTime()));
            int rows = st.executeUpdate();
            if (rows != 1) {
                log.error((Object)("Unable to insert timer for: " + timedObjectId));
            }
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectTimers(ObjectName containerId) throws SQLException {
        ArrayList<TimerHandleImpl> arrayList;
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            ArrayList<TimerHandleImpl> list = new ArrayList<TimerHandleImpl>();
            st = con.createStatement();
            rs = st.executeQuery("select * from " + this.getTableName());
            while (rs.next()) {
                String timerId = rs.getString(this.getColumnTimerID());
                TimedObjectId targetId = TimedObjectId.parse(rs.getString(this.getColumnTargetID()));
                if (containerId != null && !containerId.equals(targetId.getContainerId())) continue;
                Timestamp initialDate = rs.getTimestamp(this.getColumnInitialDate());
                Timestamp nextTimeout = rs.getTimestamp(this.getColumnNextDate());
                long interval = rs.getLong(this.getColumnTimerInterval());
                Serializable pKey = (Serializable)this.deserialize(rs.getBytes(this.getColumnInstancePK()));
                Serializable info = null;
                try {
                    info = (Serializable)this.deserialize(rs.getBytes(this.getColumnInfo()));
                }
                catch (Exception e) {
                    log.warn((Object)"Cannot deserialize custom info object", (Throwable)e);
                }
                targetId = new TimedObjectId(targetId.getContainerId(), pKey);
                TimerHandleImpl handle = new TimerHandleImpl(timerId, targetId, initialDate, nextTimeout, interval, info);
                list.add(handle);
            }
            arrayList = list;
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTimer(String timerId, TimedObjectId timedObjectId) throws SQLException {
        Connection con = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            String sql = "delete from " + this.getTableName() + " where " + this.getColumnTimerID() + "=? and " + this.getColumnTargetID() + "=?";
            st = con.prepareStatement(sql);
            st.setString(1, timerId);
            st.setString(2, timedObjectId.toString());
            int rows = st.executeUpdate();
            if (rows != 1) {
                log.debug((Object)("Unable to remove timer for: " + timerId));
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTimers() throws SQLException {
        Connection con = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            st = con.prepareStatement("delete from " + this.getTableName());
            st.executeUpdate();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateNextTimeout(String timerId, TimedObjectId timedObjectId, Date nextTimeout) throws SQLException {
        if (timerId == null) throw new NullPointerException();
        if (timedObjectId == null) {
            throw new NullPointerException();
        }
        log.debug((Object)("Updating next timeout date to " + nextTimeout + " for timer: " + timerId + " ,timedObjectId: " + timedObjectId.toString()));
        Connection con = null;
        PreparedStatement st = null;
        try {
            block9: {
                try {
                    con = this.ds.getConnection();
                    String sql = "update " + this.getTableName() + " " + " SET " + this.getColumnNextDate() + "=?" + " where " + this.getColumnTimerID() + "=? and " + this.getColumnTargetID() + "=?";
                    st = con.prepareStatement(sql);
                    if (nextTimeout == null) {
                        JDBCTypeMappingMetaData typeMapping = (JDBCTypeMappingMetaData)this.server.getAttribute(this.metaDataName, "TypeMappingMetaData");
                        if (typeMapping == null) {
                            throw new IllegalStateException("Cannot obtain type mapping from: " + this.metaDataName);
                        }
                        int dateType = typeMapping.getTypeMappingMetaData(Timestamp.class).getJdbcType();
                        st.setNull(1, dateType);
                    } else {
                        st.setTimestamp(1, new Timestamp(nextTimeout.getTime()));
                    }
                    st.setString(2, timerId);
                    st.setString(3, timedObjectId.toString());
                    int rows = st.executeUpdate();
                    if (rows == 1) break block9;
                    log.debug((Object)("Unexpected update row count: " + rows + " for timer: " + timerId + " timedObjectId: " + timedObjectId.toString()));
                }
                catch (SQLException sqle) {
                    throw sqle;
                }
                catch (Exception e) {
                    log.error((Object)("Could not update next timeout date for timerId: " + timerId + " timedObjectId: " + timedObjectId.toString()), (Throwable)e);
                    Object var10_13 = null;
                    JDBCUtil.safeClose(st);
                    JDBCUtil.safeClose(con);
                    return;
                }
            }
            Object var10_12 = null;
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            return;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnTimerID() {
        return "TIMERID";
    }

    public String getColumnTargetID() {
        return "TARGETID";
    }

    public String getColumnInitialDate() {
        return "INITIALDATE";
    }

    public String getColumnNextDate() {
        return "NEXTDATE";
    }

    public String getColumnTimerInterval() {
        return "TIMERINTERVAL";
    }

    public String getColumnInstancePK() {
        return "INSTANCEPK";
    }

    public String getColumnInfo() {
        return "INFO";
    }

    protected byte[] serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
        }
        catch (IOException e) {
            log.error((Object)("Cannot serialize: " + obj), (Throwable)e);
        }
        return baos.toByteArray();
    }

    protected Object deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try {
            MarshalledValueInputStream oos = new MarshalledValueInputStream(bais);
            return oos.readObject();
        }
        catch (Exception e) {
            log.error((Object)"Cannot deserialize", (Throwable)e);
            return null;
        }
    }

    protected Object deserialize(InputStream input) {
        if (input == null) {
            return null;
        }
        byte[] barr = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try {
            int b = 0;
            while ((b = input.read(barr)) > 0) {
                baos.write(barr, 0, b);
            }
            return this.deserialize(baos.toByteArray());
        }
        catch (Exception e) {
            log.error((Object)"Cannot deserialize", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNextDateColumnPresent() {
        boolean bl;
        Connection con = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            String sql = "select " + this.getColumnNextDate() + " from " + this.getTableName() + " where " + this.getColumnTimerID() + "=?";
            st = con.prepareStatement(sql);
            st.setString(1, "");
            rs = st.executeQuery();
            bl = true;
            Object var7_8 = null;
        }
        catch (SQLException sqle) {
            boolean bl2;
            try {
                bl2 = false;
                Object var7_9 = null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(st);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            return bl2;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
        return bl;
    }
}

