/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.AdviceType;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.ScopedInterceptorFactory;
import org.jboss.aop.microcontainer.beans.Aspect;
import org.jboss.aop.microcontainer.beans.BindingEntry;

public final class InterceptorEntry
extends BindingEntry
implements Cloneable {
    Aspect aspect;
    String aspectMethod;
    InterceptorFactory interceptorFactory;
    boolean forStack;
    AdviceType type = AdviceType.AROUND;

    public AdviceType getType() {
        return this.type;
    }

    public void setType(AdviceType type) {
        this.type = type;
    }

    public Aspect getAspect(Aspect aspect) {
        return aspect;
    }

    public void setAspect(Aspect aspect) {
        this.aspect = aspect;
    }

    public void setForStack(boolean forStack) {
        this.forStack = forStack;
    }

    public String getAspectMethod() {
        return this.aspectMethod;
    }

    public void setAspectMethod(String aspectMethod) {
        this.aspectMethod = aspectMethod;
    }

    public InterceptorFactory[] getInterceptorFactories() {
        return new InterceptorFactory[]{this.interceptorFactory};
    }

    public InterceptorFactory getInterceptorFactory() {
        return this.interceptorFactory;
    }

    public void start() {
        if (this.manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        if (this.binding == null && !this.forStack) {
            throw new IllegalArgumentException("Null aspect binding");
        }
        if (this.aspect == null) {
            throw new IllegalArgumentException("Null aspect");
        }
        this.interceptorFactory = this.aspectMethod == null ? new ScopedInterceptorFactory(this.aspect.getDefinition()) : new AdviceFactory(this.aspect.getDefinition(), this.aspectMethod);
        this.manager.addInterceptorFactory(this.name, this.interceptorFactory);
        if (this.binding != null) {
            this.aspect.addBinding(this.binding);
        }
    }

    public void stop() {
        this.manager.removeInterceptorFactory(this.name);
        if (this.binding != null) {
            this.aspect.removeBinding(this.binding);
        }
        this.interceptorFactory = null;
    }

    public Object clone() {
        InterceptorEntry entry = new InterceptorEntry();
        entry.manager = this.manager;
        entry.binding = this.binding;
        entry.aspect = this.aspect;
        entry.aspectMethod = this.aspectMethod;
        return entry;
    }
}

