/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;

public class CanonicalResourceKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final KeyTypePlugin resourceKeyTypePlugin;
    private final List<KeyTypePlugin> ancestorKeyTypePlugins;

    public CanonicalResourceKey(Resource resource, Resource parent) throws PluginContainerException {
        if (resource == null) {
            throw new PluginContainerException("resource must not be null");
        }
        if (parent == null) {
            throw new PluginContainerException("parent must not be null");
        }
        this.resourceKeyTypePlugin = new KeyTypePlugin(resource.getResourceKey(), resource.getResourceType());
        this.ancestorKeyTypePlugins = new ArrayList<KeyTypePlugin>(5);
        while (parent != null) {
            KeyTypePlugin ktp = new KeyTypePlugin(parent.getResourceKey(), parent.getResourceType());
            this.ancestorKeyTypePlugins.add(ktp);
            parent = parent.getParentResource();
        }
    }

    public String getResourceKey() {
        return this.resourceKeyTypePlugin.key;
    }

    public String getResourceTypeName() {
        return this.resourceKeyTypePlugin.type;
    }

    public String getResourcePlugin() {
        return this.resourceKeyTypePlugin.plugin;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        int ancestor = 0;
        for (KeyTypePlugin ktp : this.ancestorKeyTypePlugins) {
            builder.append("ancestor#").append(ancestor++).append("=").append(ktp).append(',');
        }
        builder.append("resource=").append(this.resourceKeyTypePlugin);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.resourceKeyTypePlugin.hashCode();
        for (KeyTypePlugin ktp : this.ancestorKeyTypePlugins) {
            result = 31 * result + ktp.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CanonicalResourceKey)) {
            return false;
        }
        CanonicalResourceKey other = (CanonicalResourceKey)obj;
        if (!this.resourceKeyTypePlugin.equals(other.resourceKeyTypePlugin)) {
            return false;
        }
        return ((Object)this.ancestorKeyTypePlugins).equals(other.ancestorKeyTypePlugins);
    }

    private class KeyTypePlugin {
        public final String key;
        public final String type;
        public final String plugin;

        KeyTypePlugin(String key, ResourceType type) throws PluginContainerException {
            if (key == null) {
                throw new PluginContainerException("key must not be null");
            }
            if (type == null) {
                throw new PluginContainerException("type must not be null");
            }
            if (type.getName() == null) {
                throw new PluginContainerException("type name must not be null");
            }
            if (type.getPlugin() == null) {
                throw new PluginContainerException("plugin must not be null");
            }
            this.key = key;
            this.type = type.getName();
            this.plugin = type.getPlugin();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[key=").append(this.key).append(",type=").append(this.type).append(",plugin=").append(this.plugin).append("]");
            return builder.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.key.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.plugin.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof KeyTypePlugin)) {
                return false;
            }
            KeyTypePlugin other = (KeyTypePlugin)obj;
            if (!this.key.equals(other.key)) {
                return false;
            }
            if (!this.plugin.equals(other.plugin)) {
                return false;
            }
            return this.type.equals(other.type);
        }
    }
}

