/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pc.plugin.PluginFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemPluginFinder
implements PluginFinder {
    private final Log log = LogFactory.getLog(FileSystemPluginFinder.class);
    private static final FilenameFilter JAR_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    };
    private List<File> deploymentDirectories = new ArrayList<File>();
    private Map<File, Long> pluginModifiedTimes = new HashMap<File, Long>();

    public FileSystemPluginFinder(File pluginDir) {
        this.deploymentDirectories.add(pluginDir);
    }

    public FileSystemPluginFinder(Collection<File> pluginDirs) {
        this.deploymentDirectories.addAll(pluginDirs);
    }

    @Override
    public Collection<URL> findPlugins() {
        HashSet<URL> allPluginUrls = new HashSet<URL>();
        for (File deploymentDirectory : this.deploymentDirectories) {
            Collection<URL> dirPluginUrls = this.findPluginsInDirectory(deploymentDirectory);
            allPluginUrls.addAll(dirPluginUrls);
        }
        return allPluginUrls;
    }

    private Collection<URL> findPluginsInDirectory(File pluginDir) {
        HashSet<URL> pluginUrls = new HashSet<URL>();
        File[] jars = pluginDir.listFiles(JAR_FILTER);
        if (jars == null) {
            return pluginUrls;
        }
        for (File jar : jars) {
            if (this.pluginModifiedTimes.containsKey(jar) && jar.lastModified() == this.pluginModifiedTimes.get(jar).longValue()) continue;
            this.pluginModifiedTimes.put(jar, jar.lastModified());
            try {
                URL jarUrl = jar.toURL();
                pluginUrls.add(jarUrl);
            }
            catch (MalformedURLException e) {
                this.log.error((Object)("Could not get URL for plugin jar: " + jar));
            }
        }
        return pluginUrls;
    }
}

