/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security.authenticators;

import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.security.authenticators.JASPIFormAuthenticator;
import org.jboss.web.tomcat.security.authenticators.SecurityAssociationActions;

public class ExtendedJASPIFormAuthenticator
extends JASPIFormAuthenticator {
    private static Logger log = Logger.getLogger(ExtendedJASPIFormAuthenticator.class);
    private static boolean trace = log.isTraceEnabled();
    private boolean includePassword;

    public boolean isIncludePassword() {
        return this.includePassword;
    }

    public void setIncludePassword(boolean includePassword) {
        this.includePassword = includePassword;
    }

    protected void forwardToErrorPage(Request request, Response response, LoginConfig config) {
        if (trace) {
            log.trace((Object)"forwardToErrorPage");
        }
        this.populateSession(request);
        super.forwardToErrorPage(request, response, config);
        SecurityAssociationActions.clearAuthException();
    }

    protected void forwardToLoginPage(LoginConfig config, Request request, Response response) {
        if (trace) {
            log.trace((Object)"forwardToLoginPage");
        }
        this.populateSession(request);
        super.forwardToLoginPage(request, response, config);
    }

    protected void populateSession(Request request) {
        String username = request.getParameter("j_username");
        HttpSession session = request.getSession(false);
        if (trace) {
            log.trace((Object)("Enter, j_username=" + username));
        }
        if (session != null) {
            String pass;
            if (username != null) {
                session.setAttribute("j_username", (Object)username);
            }
            if (this.includePassword && (pass = request.getParameter("j_password")) != null) {
                session.setAttribute("j_password", (Object)pass);
            }
        }
        username = request.getParameter("j_username");
        session = request.getSession(false);
        if (session != null) {
            if (trace) {
                log.trace((Object)("SessionID: " + session.getId()));
            }
            if (username != null) {
                session.setAttribute("j_username", (Object)username);
            }
            Throwable t = SecurityAssociationActions.getAuthException();
            if (trace) {
                log.trace((Object)("SecurityAssociation.exception: " + t));
            }
            if (t != null) {
                session.setAttribute("j_exception", (Object)t);
            }
        }
        if (trace) {
            log.trace((Object)("Exit, username: " + username));
        }
    }
}

