/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.ManagedDeploymentImpl;
import org.jboss.managed.plugins.jmx.ManagementFactoryUtils;
import org.jboss.profileservice.management.ManagedOperationProxyFactory;
import org.jboss.profileservice.management.views.AbstractProfileView;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;

public class PlatformMbeansView
extends AbstractProfileView {
    private static final ManagedObjectFactory managedObjFactory = ManagedObjectFactory.getInstance();
    private static final ProfileKey key = new ProfileKey(PlatformMbeansView.class.getName());

    protected static ManagedDeployment getDeployment() {
        Map platformMBeanMOs = ManagementFactoryUtils.getPlatformMBeanMOs((ManagedObjectFactory)managedObjFactory);
        ManagedDeploymentImpl platformMBeans = new ManagedDeploymentImpl("JDK PlatformMBeans", "PlatformMBeans", null, platformMBeanMOs);
        List gcMbeans = ManagementFactoryUtils.getGarbageCollectorMXBeans((ManagedObjectFactory)managedObjFactory);
        HashMap<String, ManagedObject> gcMOs = new HashMap<String, ManagedObject>();
        for (ManagedObject mo : gcMbeans) {
            gcMOs.put(mo.getName(), mo);
        }
        List mmMbeans = ManagementFactoryUtils.getMemoryManagerMXBeans((ManagedObjectFactory)managedObjFactory);
        HashMap<String, ManagedObject> mmMOs = new HashMap<String, ManagedObject>();
        for (ManagedObject mo : mmMbeans) {
            mmMOs.put(mo.getName(), mo);
        }
        List mpoolMBeans = ManagementFactoryUtils.getMemoryPoolMXBeans((ManagedObjectFactory)managedObjFactory);
        HashMap<String, ManagedObject> mpoolMOs = new HashMap<String, ManagedObject>();
        for (ManagedObject mo : mpoolMBeans) {
            mpoolMOs.put(mo.getName(), mo);
        }
        ManagedDeploymentImpl gcMD = new ManagedDeploymentImpl("GarbageCollectorMXBeans", "GarbageCollectorMXBeans", null, gcMOs);
        platformMBeans.getChildren().add(gcMD);
        ManagedDeploymentImpl mmMD = new ManagedDeploymentImpl("MemoryManagerMXBeans", "MemoryManagerMXBeans", null, mmMOs);
        platformMBeans.getChildren().add(mmMD);
        ManagedDeploymentImpl mpoolMD = new ManagedDeploymentImpl("MemoryPoolMXBeans", "MemoryPoolMXBeans", null, mpoolMOs);
        platformMBeans.getChildren().add(mpoolMD);
        return platformMBeans;
    }

    public PlatformMbeansView(ManagedOperationProxyFactory proxyFactory) throws Exception {
        super(proxyFactory);
        this.processManagedDeployment(PlatformMbeansView.getDeployment(), DeploymentState.STARTED, 0, false);
    }

    public ProfileKey getProfileKey() {
        return key;
    }

    public boolean hasBeenModified(Profile profile) {
        return false;
    }
}

