/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.util.Util;

public class MessageDispatcherSpeedTest
implements MembershipListener,
RequestHandler {
    Channel channel;
    MessageDispatcher disp;
    String props = null;
    boolean server = false;
    int num = 1000;
    int received = 0;
    static final long TIMEOUT = 10000L;

    public MessageDispatcherSpeedTest(String props, boolean server, int num) {
        this.props = props;
        this.server = server;
        this.num = num;
    }

    @Override
    public Object handle(Message msg) {
        ++this.received;
        if (this.received % 1000 == 0) {
            System.out.println("-- received " + this.received);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        this.channel = new JChannel(this.props);
        this.disp = new MessageDispatcher(this.channel, null, (MembershipListener)this, this, false);
        this.channel.connect("MessageDispatcherSpeedTestGroup");
        try {
            if (this.server) {
                System.out.println("-- Started as server. Press ctrl-c to kill");
                while (true) {
                    Util.sleep(10000L);
                }
            }
            this.sendMessages(this.num);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            this.channel.close();
            this.disp.stop();
        }
    }

    void sendMessages(int num) throws Exception {
        int show = num / 10;
        if (show <= 0) {
            show = 1;
        }
        long start = System.currentTimeMillis();
        System.out.println("-- sending " + num + " messages");
        for (int i = 1; i <= num; ++i) {
            this.disp.castMessage(null, new Message(), 2, 10000L);
            if (i % show != 0) continue;
            System.out.println("-- sent " + i);
        }
        long stop = System.currentTimeMillis();
        this.printStats(stop - start, num);
    }

    void printStats(long total_time, int num) {
        double throughput = (double)num / ((double)total_time / 1000.0);
        System.out.println("time for " + num + " remote calls was " + total_time + ", avg=" + (double)total_time / (double)num + "ms/invocation, " + (long)throughput + " calls/sec");
    }

    @Override
    public void viewAccepted(View new_view) {
        System.out.println("-- new view: " + new_view);
    }

    @Override
    public void suspect(Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    public static void main(String[] args) {
        String props = null;
        boolean server = false;
        int num = 1000;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-server".equals(args[i])) {
                server = true;
                continue;
            }
            if ("-num".equals(args[i])) {
                num = Integer.parseInt(args[++i]);
                continue;
            }
            MessageDispatcherSpeedTest.help();
            return;
        }
        try {
            MessageDispatcherSpeedTest test = new MessageDispatcherSpeedTest(props, server, num);
            test.start();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println("RpcDispatcherSpeedTest [-help] [-props <props>] [-server] [-num <number of calls>]");
    }
}

