/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.resource.InternetResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.renderkit.html.HtmlRichMessageRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RichMessageBaseRenderer
extends HeaderResourcesRendererBase {
    protected static final Log log = LogFactory.getLog(HtmlRichMessageRenderer.class);
    public static final String COMPONENT_NOT_FOUND_IN_VIEW_WARN_MESSAGE = "component not found in the view WARNING";
    private static final String ERROR_NAME = "ERROR";
    private static final String WARN_NAME = "WARN";
    private static final String FATAL_NAME = "FATAL";
    private static final String INFO_NAME = "INFO";
    private static final String ALL_NAME = "ALL";
    private final InternetResource[] styles = new InternetResource[]{this.getResource("/org/richfaces/renderkit/html/css/msg.css"), this.getResource("/org/richfaces/renderkit/html/css/msgs.css")};
    private InternetResource[] stylesAll = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternetResource[] getStyles() {
        RichMessageBaseRenderer richMessageBaseRenderer = this;
        synchronized (richMessageBaseRenderer) {
            if (this.stylesAll == null) {
                boolean ignoreThis;
                InternetResource[] rsrcs = super.getStyles();
                boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
                boolean bl = ignoreThis = this.styles == null || this.styles.length == 0;
                if (ignoreSuper) {
                    this.stylesAll = ignoreThis ? new InternetResource[0] : this.styles;
                } else if (ignoreThis) {
                    this.stylesAll = rsrcs;
                } else {
                    int i;
                    LinkedHashSet<InternetResource> rsrcsSet = new LinkedHashSet<InternetResource>();
                    for (i = 0; i < rsrcs.length; ++i) {
                        rsrcsSet.add(rsrcs[i]);
                    }
                    for (i = 0; i < this.styles.length; ++i) {
                        rsrcsSet.add(this.styles[i]);
                    }
                    this.stylesAll = rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
                }
            }
        }
        return this.stylesAll;
    }

    protected Iterator<FacesMessage> getMessageIterator(FacesContext context, String forClientId, UIComponent component) throws IOException {
        UIComponent result;
        Iterator msgIter = null;
        msgIter = forClientId != null ? (forClientId.length() != 0 ? ((result = RendererUtils.getInstance().findComponentFor(component, forClientId)) == null ? Collections.emptyList().iterator() : context.getMessages(result.getClientId(context))) : context.getMessages(null)) : context.getMessages();
        return msgIter;
    }

    protected void renderMarkerFacet(UIComponent uiMsg, FacesContext context, ResponseWriter writer, FacesMessage facesMsg) throws IOException {
        UIComponent marker = null;
        String markerClass = null;
        String markerStyle = null;
        FacesMessage.Severity severity = null;
        if (facesMsg != null) {
            severity = facesMsg.getSeverity();
            if (severity == FacesMessage.SEVERITY_ERROR) {
                markerClass = (String)uiMsg.getAttributes().get("errorMarkerClass");
                markerStyle = (String)uiMsg.getAttributes().get("errorMarkerStyle");
                marker = uiMsg.getFacet("errorMarker");
            } else if (severity == FacesMessage.SEVERITY_FATAL) {
                markerClass = (String)uiMsg.getAttributes().get("fatalMarkerClass");
                markerStyle = (String)uiMsg.getAttributes().get("fatalMarkerStyle");
                marker = uiMsg.getFacet("fatalMarker");
            } else if (severity == FacesMessage.SEVERITY_INFO) {
                markerClass = (String)uiMsg.getAttributes().get("infoMarkerClass");
                markerStyle = (String)uiMsg.getAttributes().get("infoMarkerStyle");
                marker = uiMsg.getFacet("infoMarker");
            } else if (severity == FacesMessage.SEVERITY_WARN) {
                markerClass = (String)uiMsg.getAttributes().get("warnMarkerClass");
                markerStyle = (String)uiMsg.getAttributes().get("warnMarkerStyle");
                marker = uiMsg.getFacet("warnMarker");
            }
        } else if (uiMsg.getFacet("passedMarker") != null) {
            marker = uiMsg.getFacet("passedMarker");
            markerClass = (String)uiMsg.getAttributes().get("markerClass");
            markerStyle = (String)uiMsg.getAttributes().get("markerStyle");
        }
        if (marker == null) {
            return;
        }
        if (!marker.isRendered()) {
            return;
        }
        this.renderMarkerHtml(uiMsg, marker, context, writer, markerClass, markerStyle);
    }

    protected void renderLabel(UIComponent component, FacesContext context, ResponseWriter writer, FacesMessage facesMsg) throws IOException {
        String labelClass = null;
        String labelStyle = null;
        String passLabel = null;
        FacesMessage.Severity severity = null;
        if (facesMsg != null) {
            severity = facesMsg.getSeverity();
            if (severity == FacesMessage.SEVERITY_ERROR) {
                labelClass = (String)component.getAttributes().get("errorLabelClass");
                labelStyle = (String)component.getAttributes().get("errorLabelStyle");
            } else if (severity == FacesMessage.SEVERITY_FATAL) {
                labelClass = (String)component.getAttributes().get("fatalLabelClass");
                labelStyle = (String)component.getAttributes().get("fatalLabelStyle");
            } else if (severity == FacesMessage.SEVERITY_WARN) {
                labelClass = (String)component.getAttributes().get("warnLabelClass");
                labelStyle = (String)component.getAttributes().get("warnLabelStyle");
            } else if (severity == FacesMessage.SEVERITY_INFO) {
                labelClass = (String)component.getAttributes().get("infoLabelClass");
                labelStyle = (String)component.getAttributes().get("infoLabelStyle");
            }
        } else if (component.getAttributes().get("passedLabel") != null) {
            passLabel = (String)component.getAttributes().get("passedLabel");
            labelClass = (String)component.getAttributes().get("labelClass");
            labelStyle = (String)component.getAttributes().get("labelStyle");
        }
        this.renderLabelHtml(component, context, writer, facesMsg, labelClass, labelStyle, passLabel);
    }

    protected void outerStyles(UIComponent component, FacesContext context, ResponseWriter writer, FacesMessage facesMsg) throws IOException {
        String outerClass = null;
        String outerStyle = null;
        FacesMessage.Severity severity = null;
        if (facesMsg != null) {
            severity = facesMsg.getSeverity();
            if (severity == FacesMessage.SEVERITY_ERROR) {
                outerClass = (String)component.getAttributes().get("errorClass");
                outerStyle = (String)component.getAttributes().get("errorStyle");
            } else if (severity == FacesMessage.SEVERITY_FATAL) {
                outerClass = (String)component.getAttributes().get("fatalClass");
                outerStyle = (String)component.getAttributes().get("fatalStyle");
            } else if (severity == FacesMessage.SEVERITY_WARN) {
                outerClass = (String)component.getAttributes().get("warnClass");
                outerStyle = (String)component.getAttributes().get("warnStyle");
            } else if (severity == FacesMessage.SEVERITY_INFO) {
                outerClass = (String)component.getAttributes().get("infoClass");
                outerStyle = (String)component.getAttributes().get("infoStyle");
            }
        }
        this.renderOuterStyles(component, context, writer, outerStyle, outerClass);
    }

    protected boolean isAcceptableMessagesPresent(List<String> acceptLevels, Iterator<FacesMessage> messagesIter) {
        while (messagesIter.hasNext()) {
            FacesMessage message = messagesIter.next();
            boolean exist = this.isAcceptableMessage(message, acceptLevels);
            if (!exist) continue;
            return true;
        }
        return false;
    }

    protected boolean isAcceptableMessage(FacesMessage message, List<String> acceptLevels) {
        boolean accept = false;
        if (acceptLevels.contains(ALL_NAME) || message == null) {
            return true;
        }
        FacesMessage.Severity severity = message.getSeverity();
        if (severity == FacesMessage.SEVERITY_ERROR && acceptLevels.contains(ERROR_NAME)) {
            accept = true;
        } else if (severity == FacesMessage.SEVERITY_FATAL && acceptLevels.contains(FATAL_NAME)) {
            accept = true;
        } else if (severity == FacesMessage.SEVERITY_INFO && acceptLevels.contains(INFO_NAME)) {
            accept = true;
        } else if (severity == FacesMessage.SEVERITY_WARN && acceptLevels.contains(WARN_NAME)) {
            accept = true;
        }
        return accept;
    }

    protected List<String> creatAcceptLevels(String[] levels) {
        ArrayList<String> acceptLevels = new ArrayList<String>();
        for (int i = 0; i < levels.length; ++i) {
            acceptLevels.add(levels[i].toUpperCase());
        }
        return acceptLevels;
    }

    public abstract void renderMarkerHtml(UIComponent var1, UIComponent var2, FacesContext var3, ResponseWriter var4, String var5, String var6) throws IOException;

    public abstract void renderLabelHtml(UIComponent var1, FacesContext var2, ResponseWriter var3, FacesMessage var4, String var5, String var6, String var7) throws IOException;

    public abstract void renderOuterStyles(UIComponent var1, FacesContext var2, ResponseWriter var3, String var4, String var5) throws IOException;
}

