/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform.content.yum;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.composite.PackageVersionMetadataComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.platform.content.yum.YumContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginContext
implements YumContext {
    private final URL baseurl;
    private final ResourceContext resourceContext;
    private final ContentContext contentContext;

    public PluginContext(int port, ResourceContext resourceContext, ContentContext contentContext) throws MalformedURLException {
        this.resourceContext = resourceContext;
        this.contentContext = contentContext;
        this.baseurl = new URL("http://localhost:" + port + "/yum");
    }

    @Override
    public URL baseurl() {
        return this.baseurl;
    }

    @Override
    public String basepath() {
        return this.baseurl.getPath();
    }

    @Override
    public int port() {
        return this.baseurl.getPort();
    }

    @Override
    public long writePackageBits(PackageDetailsKey key, OutputStream ostr) {
        return this.getContentServices().downloadPackageBits(this.contentContext, key, ostr, true);
    }

    @Override
    public long writePackageBits(PackageDetailsKey key, long[] range, OutputStream ostr) {
        return this.getContentServices().downloadPackageBitsRange(this.contentContext, key, ostr, range[0], range[1], true);
    }

    @Override
    public long getPackageBitsLength(PackageDetailsKey key) {
        return this.getContentServices().getPackageBitsLength(this.contentContext, key);
    }

    @Override
    public PageList<PackageVersionMetadataComposite> getPackageVersionMetadata(PageControl pc) {
        return this.getContentServices().getPackageVersionMetadata(this.contentContext, pc);
    }

    @Override
    public String getResourceSubscriptionMD5() {
        return this.getContentServices().getResourceSubscriptionMD5(this.contentContext);
    }

    @Override
    public File getTemporaryDirectory() {
        return this.resourceContext.getTemporaryDirectory();
    }

    @Override
    public Configuration getPluginConfiguration() {
        return this.resourceContext.getPluginConfiguration();
    }

    @Override
    public long getMetadataCacheTimeout() {
        Long timeLong;
        PropertySimple p;
        long time = 1800L;
        Configuration config = this.getPluginConfiguration();
        if (config != null && (p = config.getSimple("metadataCacheTimeout")) != null && (timeLong = p.getLongValue()) != null) {
            time = timeLong;
        }
        return time;
    }

    private ContentServices getContentServices() {
        return this.contentContext.getContentServices();
    }
}

