/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.expressions;

import com.google.common.collect.Maps;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.el.FunctionMapper;
import org.apache.shindig.expressions.OpensocialFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ImplementedBy(value=DefaultFunctions.class)
public class Functions
extends FunctionMapper {
    private final Map<String, Map<String, Method>> functions = Maps.newHashMap();

    public Functions(Class<?> ... functionClasses) {
        for (Class<?> functionClass : functionClasses) {
            for (Method m : functionClass.getMethods()) {
                if ((m.getModifiers() & 8) == 0) continue;
                this.addMethod(m);
            }
        }
    }

    public Method resolveFunction(String prefix, String methodName) {
        Map<String, Method> prefixMap = this.functions.get(prefix);
        if (prefixMap == null) {
            return null;
        }
        return prefixMap.get(methodName);
    }

    private void addMethod(Method m) {
        Expose annotation = m.getAnnotation(Expose.class);
        if (m.isAnnotationPresent(Expose.class)) {
            String prefix = annotation.prefix();
            HashMap prefixMap = this.functions.get(prefix);
            if (prefixMap == null) {
                prefixMap = Maps.newHashMap();
                this.functions.put(prefix, prefixMap);
            }
            for (String methodName : annotation.names()) {
                Method priorMethod = prefixMap.put(methodName, m);
                if (priorMethod == null) continue;
                throw new IllegalStateException("Method " + prefix + ":" + methodName + " re-defined.");
            }
        }
    }

    static class DefaultFunctions
    extends Functions {
        @Inject
        public DefaultFunctions() {
            super(OpensocialFunctions.class);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Expose {
        public String prefix();

        public String[] names() default {};
    }
}

