/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.ldap.ADSearchBySID;
import org.exoplatform.services.organization.ldap.GroupDAOImpl;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADGroupDAOImpl
extends GroupDAOImpl {
    private ADSearchBySID adSearch;

    public ADGroupDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, ADSearchBySID ad) throws Exception {
        super(ldapAttrMapping, ldapService);
        this.adSearch = ad;
    }

    @Override
    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        return this.findGroups(userName, membershipType);
    }

    @Override
    public Collection findGroupsOfUser(String userName) throws Exception {
        return this.findGroups(userName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection findGroups(String userName, String type) throws Exception {
        LdapContext ctx = this.ldapService.getLdapContext();
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            NamingEnumeration<SearchResult> results = null;
            int err = 0;
            while (true) {
                ArrayList<Group> arrayList;
                block18: {
                    String userDN;
                    block16: {
                        ArrayList<Group> arrayList2;
                        block17: {
                            groups.clear();
                            userDN = this.getDNFromUsername(ctx, userName);
                            if (userDN != null) break block16;
                            arrayList2 = groups;
                            if (results == null) break block17;
                            results.close();
                        }
                        return arrayList2;
                    }
                    try {
                        String filter = this.ldapAttrMapping.userObjectClassFilter;
                        String[] retAttrs = new String[]{"tokenGroups"};
                        SearchControls constraints = new SearchControls();
                        constraints.setSearchScope(0);
                        constraints.setReturningAttributes(retAttrs);
                        results = ctx.search(userDN, filter, constraints);
                        while (results.hasMore()) {
                            SearchResult sr = results.next();
                            Attributes attrs = sr.getAttributes();
                            Attribute attr = attrs.get("tokenGroups");
                            for (int x = 0; x < attr.size(); ++x) {
                                Group group;
                                byte[] SID = (byte[])attr.get(x);
                                String membershipDN = this.adSearch.findMembershipDNBySID(ctx, SID, this.ldapAttrMapping.groupsURL, type);
                                if (membershipDN == null || (group = this.getGroupFromMembershipDN(ctx, membershipDN)) == null || this.checkExist(group, groups)) continue;
                                groups.add(group);
                            }
                        }
                        arrayList = groups;
                        if (results == null) break block18;
                    }
                    catch (NamingException e) {
                        block19: {
                            try {
                                if (ADGroupDAOImpl.isConnectionError(e) && err < ADGroupDAOImpl.getMaxConnectionError()) {
                                    ctx = this.ldapService.getLdapContext(true);
                                    break block19;
                                }
                                throw e;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (results != null) {
                                    results.close();
                                }
                            }
                        }
                        ++err;
                        continue;
                    }
                    results.close();
                }
                return arrayList;
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    private boolean checkExist(Group group, List<Group> list) {
        for (Group ele : list) {
            if (!ele.getId().equals(group.getId())) continue;
            return true;
        }
        return false;
    }
}

