/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.text;

import java.io.StringWriter;
import org.gatein.common.io.WriterCharWriter;
import org.gatein.common.text.CharEncoder;
import org.gatein.common.text.CharWriter;
import org.gatein.common.text.EncodingException;
import org.gatein.common.util.ParameterValidation;

public abstract class AbstractCharEncoder
implements CharEncoder {
    public void encode(char[] chars, int off, int len, CharWriter writer) throws EncodingException {
        ParameterValidation.throwIllegalArgExceptionIfRangeInvalid(chars, off, len);
        ParameterValidation.throwIllegalArgExceptionIfNull(writer, "CharWriter");
        this.safeEncode(chars, off, len, writer);
    }

    public void encode(char[] chars, CharWriter writer) throws EncodingException {
        ParameterValidation.throwIllegalArgExceptionIfNull(chars, "char[]");
        this.encode(chars, 0, chars.length, writer);
    }

    public void encode(CharSequence s, CharWriter writer) throws EncodingException {
        ParameterValidation.throwIllegalArgExceptionIfNull(s, "CharSequence");
        if (s instanceof String) {
            char[] chars = ((String)s).toCharArray();
            this.encode(chars, 0, chars.length, writer);
        } else {
            char[] chars = new char[s.length()];
            for (int i = 0; i < s.length(); ++i) {
                char c;
                chars[i] = c = s.charAt(i);
            }
            this.encode(chars, 0, chars.length, writer);
        }
    }

    public void encode(char c, CharWriter writer) throws EncodingException {
        this.encode(new char[]{c}, writer);
    }

    public String encode(String string) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNull(string, "String");
        StringWriter sw = new StringWriter();
        WriterCharWriter charWriter = new WriterCharWriter(sw);
        this.safeEncode(string.toCharArray(), 0, string.length(), charWriter);
        return ((Object)sw).toString();
    }

    protected abstract void safeEncode(char[] var1, int var2, int var3, CharWriter var4) throws EncodingException;
}

