/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.bdbje;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.bdbje.BdbjeCacheLoaderConfig;
import org.jboss.cache.marshall.NodeData;
import org.jboss.cache.util.reflect.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BdbjeCacheLoader
extends AbstractCacheLoader {
    private static final int MAX_TXN_RETRIES = 10;
    private static final char LOWEST_UTF_CHAR = '\u0001';
    private static final Log log = LogFactory.getLog(BdbjeCacheLoader.class);
    private BdbjeCacheLoaderConfig config;
    private Environment env;
    private String cacheDbName;
    private String catalogDbName;
    private Database cacheDb;
    private Database catalogDb;
    private StoredClassCatalog catalog;
    private SerialBinding serialBinding;
    private Map<Object, Transaction> txnMap;
    private boolean transactional;

    @Override
    public void create() throws Exception {
        String license = "\n*************************************************************************************\nBerkeley DB Java Edition version: " + JEVersion.CURRENT_VERSION.toString() + "\n" + "JBoss Cache can use Berkeley DB Java Edition from Oracle \n" + "(http://www.oracle.com/database/berkeley-db/je/index.html)\n" + "for persistent, reliable and transaction-protected data storage.\n" + "If you choose to use Berkeley DB Java Edition with JBoss Cache, you must comply with the terms\n" + "of Oracle's public license, included in the file LICENSE.txt.\n" + "If you prefer not to release the source code for your own application in order to comply\n" + "with the Oracle public license, you may purchase a different license for use of\n" + "Berkeley DB Java Edition with JBoss Cache.\n" + "See http://www.oracle.com/database/berkeley-db/je/index.html for pricing and license terms\n" + "*************************************************************************************";
        System.out.println(license);
        log.trace((Object)"Creating BdbjeCacheLoader instance.");
        this.checkNotOpen();
    }

    @Override
    protected void storeStateHelper(Fqn subtree, List nodeData, boolean moveToBuddy) throws Exception {
        for (Object aNodeData : nodeData) {
            NodeData nd = (NodeData)aNodeData;
            if (nd.isMarker()) {
                if (!log.isTraceEnabled()) break;
                log.trace((Object)"Reached delimiter; exiting loop");
                break;
            }
            Fqn fqn = moveToBuddy ? this.buddyFqnTransformer.getBackupFqn(subtree, nd.getFqn()) : nd.getFqn();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Storing state in Fqn " + fqn));
            }
            if (nd.getAttributes() != null) {
                this.put(fqn, nd.getAttributes(), true);
                continue;
            }
            this.put(fqn, (Map)null);
        }
    }

    @Override
    public void start() throws Exception {
        boolean created;
        int offset;
        log.trace((Object)"Starting BdbjeCacheLoader instance.");
        this.checkNotOpen();
        if (this.cache == null) {
            throw new IllegalStateException("A non-null Cache property (CacheSPI object) is required");
        }
        String configStr = this.config.getLocation();
        if (this.config.getLocation() == null) {
            configStr = System.getProperty("java.io.tmpdir");
            ReflectionUtil.setValue(this.config, "accessible", true);
            this.config.setLocation(configStr);
        }
        if ((offset = configStr.indexOf(35)) >= 0 && offset < configStr.length() - 1) {
            this.cacheDbName = configStr.substring(offset + 1);
            configStr = configStr.substring(0, offset);
        } else {
            this.cacheDbName = this.cache.getClusterName();
            if (this.cacheDbName == null) {
                this.cacheDbName = "CacheInstance-" + System.identityHashCode(this.cache);
            }
        }
        File location = new File(configStr);
        if (!location.exists() && !(created = location.mkdirs())) {
            throw new IOException("Unable to create cache loader location " + location);
        }
        if (!location.isDirectory()) {
            throw new IOException("Cache loader location [" + location + "] is not a directory!");
        }
        this.catalogDbName = this.cacheDbName + "_class_catalog";
        this.transactional = this.cache.getTransactionManager() != null;
        try {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setAllowCreate(true);
            envConfig.setTransactional(true);
            envConfig.setLockTimeout(1000L * this.cache.getConfiguration().getLockAcquisitionTimeout());
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating JE environment with home dir " + location));
            }
            this.env = new Environment(location, envConfig);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created JE environment " + this.env + " for cache loader " + this));
            }
            this.openDatabases();
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    private void openDatabases() throws Exception {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(this.transactional);
        this.cacheDb = this.env.openDatabase(null, this.cacheDbName, dbConfig);
        this.catalogDb = this.env.openDatabase(null, this.catalogDbName, dbConfig);
        this.catalog = new StoredClassCatalog(this.catalogDb);
        this.serialBinding = new SerialBinding((ClassCatalog)this.catalog, null);
        this.txnMap = new ConcurrentHashMap<Object, Transaction>();
    }

    private void closeDatabases() {
        if (this.cacheDb != null) {
            try {
                this.cacheDb.close();
            }
            catch (Exception shouldNotOccur) {
                log.warn((Object)"Caught unexpected exception", (Throwable)shouldNotOccur);
            }
        }
        if (this.catalogDb != null) {
            try {
                this.catalogDb.close();
            }
            catch (Exception shouldNotOccur) {
                log.warn((Object)"Caught unexpected exception", (Throwable)shouldNotOccur);
            }
        }
        this.cacheDb = null;
        this.catalogDb = null;
        this.catalog = null;
        this.serialBinding = null;
        this.txnMap = null;
    }

    @Override
    public void stop() {
        this.closeDatabases();
        if (this.env != null) {
            try {
                this.env.close();
            }
            catch (Exception shouldNotOccur) {
                log.warn((Object)"Unexpected exception", (Throwable)shouldNotOccur);
            }
        }
        this.env = null;
    }

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.checkNotOpen();
        this.config = base instanceof BdbjeCacheLoaderConfig ? (BdbjeCacheLoaderConfig)base : new BdbjeCacheLoaderConfig(base);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Configuring cache loader with location = " + this.config.getLocation()));
        }
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    @Override
    public void setCache(CacheSPI c) {
        super.setCache(c);
        this.checkNotOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getChildrenNames(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        DatabaseEntry prefixEntry = this.makeKeyEntry(name);
        DatabaseEntry dataEntry = new DatabaseEntry();
        dataEntry.setPartial(0, 0, true);
        String namePart = "";
        int namePartIndex = name.size();
        HashSet<String> set = null;
        Cursor cursor = this.cacheDb.openCursor(null, null);
        try {
            DatabaseEntry keyEntry;
            OperationStatus status;
            while ((status = cursor.getSearchKeyRange(keyEntry = this.makeKeyEntry(prefixEntry, namePart), dataEntry, null)) == OperationStatus.SUCCESS) {
                if (!this.startsWith(keyEntry, prefixEntry)) {
                    break;
                }
                if (set == null) {
                    set = new HashSet<String>();
                }
                Fqn childName = this.makeKeyObject(keyEntry);
                namePart = childName.get(namePartIndex).toString();
                set.add(namePart);
                namePart = namePart + '\u0001';
            }
        }
        finally {
            cursor.close();
        }
        if (set != null) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    @Override
    public Map<Object, Object> get(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        DatabaseEntry foundData = new DatabaseEntry();
        OperationStatus status = this.cacheDb.get(null, keyEntry, foundData, null);
        if (status == OperationStatus.SUCCESS) {
            return this.makeDataObject(foundData);
        }
        return null;
    }

    @Override
    public boolean exists(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        DatabaseEntry foundData = new DatabaseEntry();
        foundData.setPartial(0, 0, true);
        OperationStatus status = this.cacheDb.get(null, keyEntry, foundData, null);
        return status == OperationStatus.SUCCESS;
    }

    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        Object oldVal;
        this.checkOpen();
        this.checkNonNull(name, "name");
        if (this.transactional) {
            Modification mod = new Modification(Modification.ModificationType.PUT_KEY_VALUE, name, key, value);
            this.commitModification(mod);
            oldVal = mod.getOldValue();
        } else {
            oldVal = this.doPut(null, name, key, value);
        }
        return oldVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doPut(Transaction txn, Fqn name, Object key, Object value) throws Exception {
        Object oldVal = null;
        Map<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, value);
        DatabaseEntry dataEntry = this.makeDataEntry(map);
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        Cursor cursor = this.cacheDb.openCursor(txn, null);
        try {
            OperationStatus status = cursor.putNoOverwrite(keyEntry, dataEntry);
            if (status == OperationStatus.SUCCESS) {
                this.createParentNodes(cursor, name);
            } else {
                DatabaseEntry foundData = new DatabaseEntry();
                status = cursor.getSearchKey(keyEntry, foundData, LockMode.RMW);
                if (status == OperationStatus.SUCCESS) {
                    map = this.makeDataObject(foundData);
                    oldVal = map.put(key, value);
                    cursor.putCurrent(this.makeDataEntry(map));
                }
            }
        }
        finally {
            cursor.close();
        }
        return oldVal;
    }

    public void put(Fqn name, Map values) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        if (this.transactional) {
            this.commitModification(new Modification(Modification.ModificationType.PUT_DATA, name, values));
        } else {
            this.doPut(null, name, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPut(Transaction txn, Fqn name, Map values) throws Exception {
        if (values != null && !(values instanceof HashMap)) {
            values = new HashMap(values);
        }
        DatabaseEntry dataEntry = this.makeDataEntry(values);
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        Cursor cursor = this.cacheDb.openCursor(txn, null);
        try {
            OperationStatus status = cursor.put(keyEntry, dataEntry);
            if (status == OperationStatus.SUCCESS) {
                this.createParentNodes(cursor, name);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPutErase(Transaction txn, Fqn name, Map<Object, Object> values) throws Exception {
        values = values == null ? null : new HashMap<Object, Object>(values);
        DatabaseEntry dataEntry = this.makeDataEntry(values);
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        Cursor cursor = this.cacheDb.openCursor(txn, null);
        try {
            cursor.put(keyEntry, dataEntry);
            this.createParentNodes(cursor, name);
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
        this.checkOpen();
        this.checkNonNull(modifications, "modifications");
        if (this.transactional) {
            this.commitModifications(modifications);
        } else {
            this.doPut(null, modifications);
        }
    }

    private void doPut(Transaction txn, List<Modification> modifications) throws Exception {
        block8: for (Modification mod : modifications) {
            Fqn name = mod.getFqn();
            switch (mod.getType()) {
                case PUT_KEY_VALUE: {
                    Object oldVal = this.doPut(txn, name, mod.getKey(), mod.getValue());
                    mod.setOldValue(oldVal);
                    continue block8;
                }
                case PUT_DATA: {
                    this.doPut(txn, name, mod.getData());
                    continue block8;
                }
                case PUT_DATA_ERASE: {
                    this.doPutErase(txn, name, mod.getData());
                    continue block8;
                }
                case REMOVE_KEY_VALUE: {
                    Object oldVal = this.doRemove(txn, name, mod.getKey());
                    mod.setOldValue(oldVal);
                    continue block8;
                }
                case REMOVE_NODE: {
                    this.doRemove(txn, name);
                    continue block8;
                }
                case REMOVE_DATA: {
                    this.doRemoveData(txn, name);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown Modification type: " + (Object)((Object)mod.getType()));
        }
    }

    private void createParentNodes(Cursor cursor, Fqn name) throws Exception {
        DatabaseEntry keyEntry;
        OperationStatus status;
        DatabaseEntry dataEntry = this.makeDataEntry(null);
        for (int nParts = name.size() - 1; nParts >= 1 && (status = cursor.putNoOverwrite(keyEntry = this.makeKeyEntry(name, nParts), dataEntry)) == OperationStatus.SUCCESS; --nParts) {
        }
    }

    @Override
    public void remove(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        if (this.transactional) {
            this.commitModification(new Modification(Modification.ModificationType.REMOVE_NODE, name));
        } else {
            this.doRemove(null, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemove(Transaction txn, Fqn name) throws Exception {
        block6: {
            block5: {
                if (!name.isRoot()) break block5;
                Set<String> children = this.getChildrenNames(name);
                if (children == null) break block6;
                for (String child : children) {
                    this.doRemove(txn, Fqn.fromElements(child));
                }
                break block6;
            }
            DatabaseEntry keyEntry = this.makeKeyEntry(name);
            DatabaseEntry foundKey = new DatabaseEntry();
            DatabaseEntry foundData = new DatabaseEntry();
            foundData.setPartial(0, 0, true);
            Cursor cursor = this.cacheDb.openCursor(txn, null);
            try {
                OperationStatus status = cursor.getSearchKey(keyEntry, foundData, LockMode.RMW);
                while (status == OperationStatus.SUCCESS) {
                    cursor.delete();
                    status = cursor.getNext(foundKey, foundData, LockMode.RMW);
                    if (status != OperationStatus.SUCCESS || this.startsWith(foundKey, keyEntry)) continue;
                    status = OperationStatus.NOTFOUND;
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    @Override
    public Object remove(Fqn name, Object key) throws Exception {
        Object oldVal;
        this.checkOpen();
        this.checkNonNull(name, "name");
        if (this.transactional) {
            Modification mod = new Modification(Modification.ModificationType.REMOVE_KEY_VALUE, name, key);
            this.commitModification(mod);
            oldVal = mod.getOldValue();
        } else {
            oldVal = this.doRemove(null, name, key);
        }
        return oldVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doRemove(Transaction txn, Fqn name, Object key) throws Exception {
        Object oldVal = null;
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        DatabaseEntry foundData = new DatabaseEntry();
        Cursor cursor = this.cacheDb.openCursor(txn, null);
        try {
            OperationStatus status = cursor.getSearchKey(keyEntry, foundData, LockMode.RMW);
            if (status == OperationStatus.SUCCESS) {
                Map<Object, Object> map = this.makeDataObject(foundData);
                oldVal = map.remove(key);
                cursor.putCurrent(this.makeDataEntry(map));
            }
        }
        finally {
            cursor.close();
        }
        return oldVal;
    }

    @Override
    public void removeData(Fqn name) throws Exception {
        this.checkOpen();
        this.checkNonNull(name, "name");
        if (this.transactional) {
            this.commitModification(new Modification(Modification.ModificationType.REMOVE_DATA, name));
        } else {
            this.doRemoveData(null, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveData(Transaction txn, Fqn name) throws Exception {
        DatabaseEntry dataEntry = new DatabaseEntry();
        dataEntry.setPartial(0, 0, true);
        DatabaseEntry keyEntry = this.makeKeyEntry(name);
        Cursor cursor = this.cacheDb.openCursor(txn, null);
        try {
            OperationStatus status = cursor.getSearchKey(keyEntry, dataEntry, LockMode.RMW);
            if (status == OperationStatus.SUCCESS) {
                cursor.putCurrent(this.makeDataEntry(null));
            }
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public void prepare(Object tx, List<Modification> modifications, boolean onePhase) throws Exception {
        this.checkOpen();
        this.checkNonNull(modifications, "modifications");
        if (!onePhase) {
            this.checkNonNull(tx, "tx");
        }
        if (!this.transactional & !onePhase) {
            throw new UnsupportedOperationException("prepare() not allowed with a non-transactional cache loader");
        }
        if (onePhase) {
            for (Modification modification : modifications) {
            }
        }
        Transaction txn = this.performTransaction(modifications);
        if (onePhase) {
            txn.commit();
        } else {
            this.txnMap.put(tx, txn);
        }
    }

    private void commitModification(Modification mod) throws Exception {
        this.commitModifications(Collections.singletonList(mod));
    }

    private void commitModifications(List<Modification> mods) throws Exception {
        if (!this.transactional) {
            throw new IllegalStateException();
        }
        Transaction txn = this.performTransaction(mods);
        txn.commit();
    }

    private Transaction performTransaction(List<Modification> modifications) throws Exception {
        int retries = 10;
        while (true) {
            Transaction txn = this.env.beginTransaction(null, null);
            try {
                this.doPut(txn, modifications);
                return txn;
            }
            catch (Exception e) {
                txn.abort();
                if (e instanceof DeadlockException && retries > 0) {
                    --retries;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    @Override
    public void commit(Object tx) throws Exception {
        this.checkOpen();
        this.checkNonNull(tx, "tx");
        Transaction txn = this.txnMap.remove(tx);
        if (txn != null) {
            txn.commit();
        } else if (this.transactional) {
            throw new IllegalArgumentException("Unknown txn key: " + tx);
        }
    }

    @Override
    public void rollback(Object tx) {
        this.checkOpen();
        this.checkNonNull(tx, "tx");
        Transaction txn = this.txnMap.remove(tx);
        if (txn != null) {
            try {
                txn.abort();
            }
            catch (Exception exception) {}
        } else if (this.transactional) {
            throw new IllegalArgumentException("Unknown txn key: " + tx);
        }
    }

    private boolean startsWith(DatabaseEntry entry, DatabaseEntry prefix) {
        int size = prefix.getSize();
        if (size > entry.getSize()) {
            return false;
        }
        byte[] d1 = entry.getData();
        byte[] d2 = prefix.getData();
        int o1 = entry.getOffset();
        int o2 = prefix.getOffset();
        for (int i = 0; i < size; ++i) {
            if (d1[o1 + i] == d2[o2 + i]) continue;
            return false;
        }
        return true;
    }

    private Fqn makeKeyObject(DatabaseEntry entry) {
        Fqn<String> name = Fqn.ROOT;
        TupleInput tupleInput = TupleBinding.entryToInput((DatabaseEntry)entry);
        while (tupleInput.available() > 0) {
            String part = tupleInput.readString();
            name = Fqn.fromRelativeElements(name, part);
        }
        return name;
    }

    private DatabaseEntry makeKeyEntry(Fqn name) {
        return this.makeKeyEntry(name, name.size());
    }

    private DatabaseEntry makeKeyEntry(Fqn name, int nParts) {
        TupleOutput tupleOutput = new TupleOutput();
        for (int i = 0; i < nParts; ++i) {
            tupleOutput.writeString(name.get(i).toString());
        }
        DatabaseEntry entry = new DatabaseEntry();
        TupleBinding.outputToEntry((TupleOutput)tupleOutput, (DatabaseEntry)entry);
        return entry;
    }

    private DatabaseEntry makeKeyEntry(DatabaseEntry prefix, String namePart) {
        TupleOutput tupleOutput = new TupleOutput();
        tupleOutput.writeFast(prefix.getData(), prefix.getOffset(), prefix.getSize());
        tupleOutput.writeString(namePart);
        DatabaseEntry entry = new DatabaseEntry();
        TupleBinding.outputToEntry((TupleOutput)tupleOutput, (DatabaseEntry)entry);
        return entry;
    }

    private Map<Object, Object> makeDataObject(DatabaseEntry entry) {
        HashMap map = (HashMap)this.serialBinding.entryToObject(entry);
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    private DatabaseEntry makeDataEntry(Map<Object, Object> map) {
        if (map != null) {
            if (map.size() == 0) {
                map = null;
            } else if (!(map instanceof Serializable)) {
                map = new HashMap<Object, Object>(map);
            }
        }
        DatabaseEntry entry = new DatabaseEntry();
        this.serialBinding.objectToEntry(map, entry);
        return entry;
    }

    private void checkOpen() {
        if (this.env == null) {
            throw new IllegalStateException("Operation not allowed before calling create()");
        }
    }

    private void checkNotOpen() {
        if (this.env != null) {
            throw new IllegalStateException("Operation not allowed after calling create()");
        }
    }

    private void checkNonNull(Object param, String paramName) {
        if (param == null) {
            throw new NullPointerException("Parameter must not be null: " + paramName);
        }
    }
}

