/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.realm.text;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.JSecurityException;
import org.jsecurity.cache.CacheManager;
import org.jsecurity.io.ResourceUtils;
import org.jsecurity.realm.text.TextConfigurationRealm;
import org.jsecurity.util.Destroyable;

public class PropertiesRealm
extends TextConfigurationRealm
implements Destroyable,
Runnable {
    private static final int DEFAULT_RELOAD_INTERVAL_SECONDS = 10;
    private static final String USERNAME_PREFIX = "user.";
    private static final String ROLENAME_PREFIX = "role.";
    private static final String DEFAULT_RESOURCE_PATH = "classpath:jsecurity-users.properties";
    private static final String FAILSAFE_RESOURCE_PATH = "classpath:org/jsecurity/realm/text/default-jsecurity-users.properties";
    private static final Log log = LogFactory.getLog(PropertiesRealm.class);
    protected ExecutorService scheduler = null;
    protected boolean useXmlFormat = false;
    protected String resourcePath = "classpath:jsecurity-users.properties";
    protected long fileLastModified;
    protected int reloadIntervalSeconds = 10;

    public PropertiesRealm() {
        this.init();
    }

    public PropertiesRealm(CacheManager cacheManager) {
        if (cacheManager == null) {
            throw new IllegalArgumentException("cacheManager argument cannot be null.");
        }
        this.setCacheManager(cacheManager);
        this.init();
    }

    public void afterRoleCacheSet() {
        try {
            this.loadProperties();
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Unable to find a jsecurity-users.properties file at location [" + this.resourcePath + "].  " + "Defaulting to JSecurity's failsafe properties file (demo use only)."));
            }
            this.resourcePath = FAILSAFE_RESOURCE_PATH;
            this.loadProperties();
        }
        if (this.resourcePath.startsWith("file:") && this.scheduler != null) {
            this.startReloadThread();
        }
    }

    public void destroy() {
        block3: {
            try {
                if (this.scheduler != null) {
                    this.scheduler.shutdown();
                }
            }
            catch (Exception e) {
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)"Unable to cleanly shutdown Scheduler.  Ignoring (shutting down)...", (Throwable)e);
            }
        }
    }

    protected void startReloadThread() {
        if (this.reloadIntervalSeconds > 0) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            ((ScheduledExecutorService)this.scheduler).scheduleAtFixedRate(this, this.reloadIntervalSeconds, this.reloadIntervalSeconds, TimeUnit.SECONDS);
        }
    }

    public void run() {
        block2: {
            try {
                this.reloadPropertiesIfNecessary();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Error while reloading property files for realm.", (Throwable)e);
            }
        }
    }

    public void setUseXmlFormat(boolean useXmlFormat) {
        this.useXmlFormat = useXmlFormat;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setReloadIntervalSeconds(int reloadIntervalSeconds) {
        this.reloadIntervalSeconds = reloadIntervalSeconds;
    }

    private void loadProperties() {
        if (this.resourcePath == null || this.resourcePath.length() == 0) {
            throw new IllegalStateException("The resourcePath property is not set.  It must be set prior to this realm being initialized.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading user security information from file [" + this.resourcePath + "]..."));
        }
        Properties properties = this.loadProperties(this.resourcePath);
        this.createRealmEntitiesFromProperties(properties);
    }

    private Properties loadProperties(String resourcePath) {
        InputStream is;
        Properties props;
        block8: {
            props = new Properties();
            is = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Opening input stream for path [" + resourcePath + "]..."));
                }
                is = ResourceUtils.getInputStreamForPath(resourcePath);
                if (this.useXmlFormat) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loading properties from path [" + resourcePath + "] in XML format..."));
                    }
                    props.loadFromXML(is);
                    break block8;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading properties from path [" + resourcePath + "]..."));
                }
                props.load(is);
            }
            catch (IOException e) {
                try {
                    throw new JSecurityException("Error reading properties path [" + resourcePath + "].  " + "Initializing of the realm from this file failed.", e);
                }
                catch (Throwable throwable) {
                    ResourceUtils.close(is);
                    throw throwable;
                }
            }
        }
        ResourceUtils.close(is);
        return props;
    }

    private void reloadPropertiesIfNecessary() {
        if (this.isSourceModified()) {
            this.restart();
        }
    }

    private boolean isSourceModified() {
        return this.resourcePath.startsWith("file:") && this.isFileModified();
    }

    private boolean isFileModified() {
        File propertyFile = new File(this.resourcePath);
        long currentLastModified = propertyFile.lastModified();
        if (currentLastModified > this.fileLastModified) {
            this.fileLastModified = currentLastModified;
            return true;
        }
        return false;
    }

    private void restart() {
        if (this.resourcePath == null || this.resourcePath.length() == 0) {
            throw new IllegalStateException("The resourcePath property is not set.  It must be set prior to this realm being initialized.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading user security information from file [" + this.resourcePath + "]..."));
        }
        try {
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init();
    }

    private void createRealmEntitiesFromProperties(Properties properties) {
        StringBuffer userDefs = new StringBuffer();
        StringBuffer roleDefs = new StringBuffer();
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String key = ((String)propNames.nextElement()).trim();
            String value = properties.getProperty(key).trim();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Processing properties line - key: [" + key + "], value: [" + value + "]."));
            }
            if (this.isUsername(key)) {
                String username = this.getUsername(key);
                userDefs.append(username).append(" = ").append(value).append("\n");
                continue;
            }
            if (this.isRolename(key)) {
                String rolename = this.getRolename(key);
                roleDefs.append(rolename).append(" = ").append(value).append("\n");
                continue;
            }
            String msg = "Encountered unexpected key/value pair.  All keys must be prefixed with either 'user.' or 'role.'.";
            throw new IllegalStateException(msg);
        }
        this.setUserDefinitions(userDefs.toString());
        this.setRoleDefinitions(roleDefs.toString());
        this.processDefinitions();
    }

    protected String getName(String key, String prefix) {
        return key.substring(prefix.length(), key.length());
    }

    protected boolean isUsername(String key) {
        return key != null && key.startsWith(USERNAME_PREFIX);
    }

    protected boolean isRolename(String key) {
        return key != null && key.startsWith(ROLENAME_PREFIX);
    }

    protected String getUsername(String key) {
        return this.getName(key, USERNAME_PREFIX);
    }

    protected String getRolename(String key) {
        return this.getName(key, ROLENAME_PREFIX);
    }
}

