/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources;

import java.util.List;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleContextInfo {
    private Set<Locale> supportedLocales;
    private List<Locale> browserLocales;
    private List<Locale> cookieLocales;
    private Locale userProfileLocale;
    private String remoteUser;
    private Locale portalLocale;
    private Locale sessionLocale;
    private Locale requestLocale;

    public void setSupportedLocales(Set<Locale> supportedLocales) {
        this.supportedLocales = supportedLocales;
    }

    public Set<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    public void setBrowserLocales(List<Locale> browserLocales) {
        this.browserLocales = browserLocales;
    }

    public List<Locale> getBrowserLocales() {
        return this.browserLocales;
    }

    public void setCookieLocales(List<Locale> cookieLocales) {
        this.cookieLocales = cookieLocales;
    }

    public List<Locale> getCookieLocales() {
        return this.cookieLocales;
    }

    public void setUserProfileLocale(Locale userProfileLocale) {
        this.userProfileLocale = userProfileLocale;
    }

    public Locale getUserProfileLocale() {
        return this.userProfileLocale;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setPortalLocale(Locale portalLocale) {
        this.portalLocale = portalLocale;
    }

    public Locale getPortalLocale() {
        return this.portalLocale;
    }

    public void setSessionLocale(Locale locale) {
        this.sessionLocale = locale;
    }

    public Locale getSessionLocale() {
        return this.sessionLocale;
    }

    public Locale getRequestLocale() {
        return this.requestLocale;
    }

    public void setRequestLocale(Locale requestLocale) {
        this.requestLocale = requestLocale;
    }

    public Locale getLocaleIfSupported(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (this.supportedLocales.contains(locale)) {
            return locale;
        }
        return null;
    }

    public Locale getLocaleIfLangSupported(Locale locale) {
        Locale loc;
        if (locale == null) {
            return null;
        }
        if (this.supportedLocales.contains(locale)) {
            return locale;
        }
        if (!"".equals(locale.getCountry()) && this.supportedLocales.contains(loc = new Locale(locale.getLanguage()))) {
            return locale;
        }
        return null;
    }

    public static Locale getLocale(String portalLocaleName) {
        int pos = portalLocaleName.indexOf("_");
        if (pos < 0) {
            return new Locale(portalLocaleName);
        }
        return new Locale(portalLocaleName.substring(0, pos), portalLocaleName.substring(pos + 1));
    }

    public static String getLocaleAsString(Locale locale) {
        if (locale.getCountry().length() == 0) {
            return locale.getLanguage();
        }
        return locale.getLanguage() + "_" + locale.getCountry();
    }
}

