/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.jts;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseCoordinator;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.xa.XID;
import com.arjuna.ats.internal.jta.resources.jts.CleanupSynchronization;
import com.arjuna.ats.internal.jta.resources.jts.LocalCleanupSynchronization;
import com.arjuna.ats.internal.jta.resources.jts.orbspecific.LastResourceRecord;
import com.arjuna.ats.internal.jta.resources.jts.orbspecific.ManagedSynchronizationImple;
import com.arjuna.ats.internal.jta.resources.jts.orbspecific.SynchronizationImple;
import com.arjuna.ats.internal.jta.resources.jts.orbspecific.XAResourceRecord;
import com.arjuna.ats.internal.jta.transaction.jts.AtomicTransaction;
import com.arjuna.ats.internal.jta.utils.XAUtils;
import com.arjuna.ats.internal.jta.utils.jts.StatusConverter;
import com.arjuna.ats.internal.jta.xa.TxInfo;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.jta.common.Configuration;
import com.arjuna.ats.jta.exceptions.InactiveTransactionException;
import com.arjuna.ats.jta.exceptions.InvalidTerminationStateException;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.resources.LastResourceCommitOptimisation;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.ats.jta.xa.XAModifier;
import com.arjuna.ats.jta.xa.XidImple;
import com.arjuna.ats.jts.common.jtsPropertyManager;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.WrongTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionImple
implements Transaction,
com.arjuna.ats.jta.transaction.Transaction {
    protected AtomicTransaction _theTransaction;
    private Hashtable _resources;
    private Hashtable _duplicateResources;
    private int _suspendCount;
    private final boolean _xaTransactionTimeoutEnabled;
    private Map _txLocalResources;
    private Throwable _rollbackOnlyCallerStacktrace;
    private int lastResourceCount;
    private static final boolean ALLOW_MULTIPLE_LAST_RESOURCES;
    private static final boolean XA_TRANSACTION_TIMEOUT_ENABLED;
    private static final Class LAST_RESOURCE_OPTIMISATION_INTERFACE;
    private static ConcurrentHashMap _transactions;

    public TransactionImple() throws SubtransactionsUnavailable {
        block5: {
            this(new AtomicTransaction());
            this._theTransaction.begin();
            try {
                TwoPhaseCoordinator theTx = null;
                try {
                    theTx = (TwoPhaseCoordinator)BasicAction.Current();
                    if (theTx != null) {
                        theTx.addSynchronization(new LocalCleanupSynchronization(this));
                        break block5;
                    }
                    this.registerSynchronization(new CleanupSynchronization(this));
                }
                catch (ClassCastException ex) {
                    this.registerSynchronization(new CleanupSynchronization(this));
                }
            }
            catch (Exception ex) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.syncproblem", (Throwable)ex);
            }
        }
    }

    public boolean equals(Object obj) {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(32L, 4L, 1L, "TransactionImple.equals");
        }
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TransactionImple && this._theTransaction != null) {
            return this._theTransaction.equals(((TransactionImple)obj)._theTransaction);
        }
        return false;
    }

    public int hashCode() {
        if (this._theTransaction != null) {
            return this._theTransaction.hashCode();
        }
        return -1;
    }

    public ControlWrapper getControlWrapper() {
        if (this._theTransaction != null) {
            return this._theTransaction.getControlWrapper();
        }
        return null;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, javax.transaction.SystemException, IllegalStateException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.commit");
        }
        if (this._theTransaction != null) {
            try {
                if (!this.endSuspendedRMs()) {
                    this._theTransaction.rollbackOnly();
                }
                this._theTransaction.end(true);
            }
            catch (WrongTransaction wt) {
                throw new InactiveTransactionException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.wrongstatetx"));
            }
            catch (NoTransaction e1) {
                throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.notx"));
            }
            catch (HeuristicMixed e2) {
                throw new HeuristicMixedException();
            }
            catch (HeuristicHazard e3) {
                throw new HeuristicMixedException();
            }
            catch (TRANSACTION_ROLLEDBACK e4) {
                throw new RollbackException(e4.toString());
            }
            catch (NO_PERMISSION e5) {
                throw new SecurityException();
            }
            catch (INVALID_TRANSACTION e6) {
                throw new InactiveTransactionException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.invalidtx2"));
            }
            catch (SystemException e7) {
                throw new javax.transaction.SystemException();
            }
            finally {
                TransactionImple.removeTransaction(this);
            }
        } else {
            throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.inactivetx"));
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, javax.transaction.SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.rollback");
        }
        if (this._theTransaction != null) {
            boolean endSuspendedFailed;
            boolean bl = endSuspendedFailed = !this.endSuspendedRMs();
            if (endSuspendedFailed && jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.endsuspendfailed1");
            }
            try {
                this._theTransaction.abort();
            }
            catch (WrongTransaction e1) {
                throw new InactiveTransactionException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.wrongstatetx"));
            }
            catch (NO_PERMISSION e2) {
                throw new SecurityException();
            }
            catch (INVALID_TRANSACTION e3) {
                throw new InactiveTransactionException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.invalidtx2"));
            }
            catch (NoTransaction e4) {
                throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.notx"));
            }
            catch (SystemException e5) {
                throw new javax.transaction.SystemException();
            }
            finally {
                TransactionImple.removeTransaction(this);
            }
            if (endSuspendedFailed) {
                throw new InvalidTerminationStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.endsuspendfailed2"));
            }
        } else {
            throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.inactivetx"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRollbackOnly() throws IllegalStateException, javax.transaction.SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.setRollbackOnly");
        }
        if (this._theTransaction == null) throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.inactivetx"));
        try {
            this._theTransaction.rollbackOnly();
            if (this._rollbackOnlyCallerStacktrace != null) return;
            this._rollbackOnlyCallerStacktrace = new Throwable("setRollbackOnly called from:");
            return;
        }
        catch (NoTransaction e3) {
            throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.notx"));
        }
        catch (SystemException e4) {
            throw new javax.transaction.SystemException();
        }
    }

    public int getStatus() throws javax.transaction.SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.getStatus");
        }
        int status = 6;
        if (this._theTransaction != null) {
            try {
                return StatusConverter.convert(this._theTransaction.get_status());
            }
            catch (SystemException e2) {
                throw new javax.transaction.SystemException();
            }
        }
        return status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, javax.transaction.SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.registerSynchronization");
        }
        if (sync == null) {
            throw new javax.transaction.SystemException("TransactionImple.registerSynchronization - " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.nullparam"));
        }
        this.registerSynchronizationImple((SynchronizationImple)new ManagedSynchronizationImple(sync));
    }

    void registerSynchronizationImple(SynchronizationImple synchronizationImple) throws RollbackException, IllegalStateException, javax.transaction.SystemException {
        if (this._theTransaction != null) {
            try {
                this._theTransaction.registerSynchronization(synchronizationImple.getSynchronization());
            }
            catch (TRANSACTION_ROLLEDBACK e2) {
                throw new RollbackException(e2.toString());
            }
            catch (Inactive e3) {
                throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.inactivetx"));
            }
            catch (SynchronizationUnavailable e4) {
                throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.syncerror"));
            }
            catch (INVALID_TRANSACTION e5) {
                throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.invalidtx2"));
            }
            catch (SystemException e6) {
                throw new javax.transaction.SystemException();
            }
        } else {
            throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.inactivetx"));
        }
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, javax.transaction.SystemException {
        return this.enlistResource(xaRes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enlistResource(XAResource xaRes, Object[] params) throws RollbackException, IllegalStateException, javax.transaction.SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.enlistResource ( " + xaRes + " )");
        }
        if (xaRes == null) {
            throw new javax.transaction.SystemException("TransactionImple.enlistResource - " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.nullparam"));
        }
        int status = this.getStatus();
        switch (status) {
            case 1: {
                throw new RollbackException("TransactionImple.enlistResource - " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.markedrollback"));
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.inactivetx"));
            }
        }
        XAModifier theModifier = null;
        if (params != null && params.length >= 2 && params[1] instanceof XAModifier) {
            theModifier = (XAModifier)params[1];
        }
        try {
            block52: {
                TxInfo info = null;
                try {
                    TransactionImple transactionImple = this;
                    synchronized (transactionImple) {
                        info = (TxInfo)this._resources.get(xaRes);
                        if (info == null) {
                            info = (TxInfo)this._duplicateResources.get(xaRes);
                        }
                    }
                    if (info == null) break block52;
                    switch (info.getState()) {
                        case 2: {
                            xaRes.start(info.xid(), 0x8000000);
                            info.setState(0);
                            transactionImple = this;
                            synchronized (transactionImple) {
                                --this._suspendCount;
                            }
                            return true;
                        }
                        case 0: {
                            return true;
                        }
                        case 1: {
                            xaRes.start(info.xid(), 0x200000);
                            info.setState(0);
                            return true;
                        }
                    }
                    throw new IllegalStateException("TransactionImple.enlistResource - " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.illegalstate") + info.getState());
                }
                catch (IllegalStateException ex) {
                    throw ex;
                }
                catch (XAException exp) {
                    if (info != null) {
                        info.setState(3);
                    }
                    if (jtaLogger.loggerI18N.isWarnEnabled()) {
                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.xaerror", new Object[]{"TransactionImple.enlistResource", XAHelper.printXAErrorCode(exp)});
                    }
                    return false;
                }
            }
            Xid xid = null;
            TxInfo existingRM = this.isNewRM(xaRes);
            if (existingRM == null) {
                boolean branchRequired = true;
                TransactionImple transactionImple = this;
                synchronized (transactionImple) {
                    if (this._resources.size() == 0) {
                        branchRequired = true;
                    }
                }
                xid = this.createXid(branchRequired, theModifier);
                boolean associatedWork = false;
                int retry = 20;
                while (!associatedWork) {
                    try {
                        XAResourceRecord xaResourceRecord;
                        block53: {
                            int timeout;
                            if (this._xaTransactionTimeoutEnabled && (timeout = this._theTransaction.getTimeout()) > 0) {
                                try {
                                    xaRes.setTransactionTimeout(timeout);
                                }
                                catch (XAException te) {
                                    if (!jtaLogger.loggerI18N.isWarnEnabled()) break block53;
                                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.timeouterror", new Object[]{"TransactionImple.enlistResource", XAHelper.printXAErrorCode(te), xid});
                                }
                            }
                        }
                        if ((xaResourceRecord = this.createRecord(xaRes, params, xid)) != null) {
                            xaRes.start(xid, 0);
                            try {
                                RecoveryCoordinator recCoord = this._theTransaction.registerResource(xaResourceRecord.getResource());
                                xaResourceRecord.setRecoveryCoordinator(recCoord);
                            }
                            catch (Exception e) {
                                xaResourceRecord.rollback();
                                this.markRollbackOnly();
                                return false;
                            }
                            this._resources.put(xaRes, new TxInfo(xid));
                            return true;
                        }
                        this.markRollbackOnly();
                        return false;
                    }
                    catch (XAException e) {
                        if (e.errorCode == -3) {
                            if (retry > 0) {
                                xid = this.createXid(true, theModifier);
                            }
                            --retry;
                        } else if (e.errorCode == -8) {
                            if (retry > 0) {
                                xid = this.createXid(true, theModifier);
                            }
                            --retry;
                        } else {
                            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.starterror", new Object[]{"TransactionImple.enlistResource - XAResource.start", XAHelper.printXAErrorCode(e), xid});
                            }
                            this.markRollbackOnly();
                            throw e;
                        }
                        if (retry >= 0) continue;
                        if (jtaLogger.loggerI18N.isWarnEnabled()) {
                            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.starterror", new Object[]{"TransactionImple.enlistResource - XAResource.start", XAHelper.printXAErrorCode(e), xid});
                        }
                        this.markRollbackOnly();
                        throw new UNKNOWN();
                    }
                }
            } else {
                xid = existingRM.xid();
                try {
                    xaRes.start(xid, 0x200000);
                }
                catch (XAException ex) {
                    if (jtaLogger.loggerI18N.isWarnEnabled()) {
                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.xaerror", new Object[]{"TransactionImple.enlistResource - xa_start: ", XAHelper.printXAErrorCode(ex)});
                    }
                    this.markRollbackOnly();
                    throw ex;
                }
                this._duplicateResources.put(xaRes, new TxInfo(xid));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.markRollbackOnly();
            return false;
        }
    }

    private XAResourceRecord createRecord(XAResource xaRes, Object[] params, Xid xid) {
        Object record;
        if (xaRes instanceof LastResourceCommitOptimisation || LAST_RESOURCE_OPTIMISATION_INTERFACE != null && LAST_RESOURCE_OPTIMISATION_INTERFACE.isInstance(xaRes)) {
            if (this.lastResourceCount == 1 && jtaLogger.loggerI18N.isWarnEnabled()) {
                if (ALLOW_MULTIPLE_LAST_RESOURCES) {
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.lastResource.multipleWarning", new Object[]{xaRes});
                } else {
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.lastResource.disallow", new Object[]{xaRes});
                }
            }
            record = this.lastResourceCount++ == 0 || ALLOW_MULTIPLE_LAST_RESOURCES ? new LastResourceRecord(this, xaRes, xid, params) : null;
        } else {
            record = new XAResourceRecord(this, xaRes, xid, params);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delistResource(XAResource xaRes, int flags) throws IllegalStateException, javax.transaction.SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.delistResource ( " + xaRes + " )");
        }
        if (xaRes == null) {
            throw new javax.transaction.SystemException("TransactionImple.delistResource - " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.nullparam"));
        }
        int status = this.getStatus();
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.inactivetx"));
            }
        }
        TxInfo info = null;
        try {
            TransactionImple transactionImple = this;
            synchronized (transactionImple) {
                info = (TxInfo)this._resources.get(xaRes);
                if (info == null) {
                    info = (TxInfo)this._duplicateResources.get(xaRes);
                }
            }
            if (info == null) {
                if (jtaLogger.loggerI18N.isWarnEnabled()) {
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.unknownres", new Object[]{"TransactionImple.delistResource"});
                }
                return false;
            }
            boolean optimizedRollback = false;
            try {
                if (status == 1 && XAUtils.canOptimizeDelist(xaRes)) {
                    xaRes.end(info.xid(), 0x20000000);
                    xaRes.rollback(info.xid());
                    info.setState(4);
                    optimizedRollback = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            switch (info.getState()) {
                case 0: {
                    if ((flags & 0x4000000) != 0) {
                        xaRes.end(info.xid(), 0x4000000);
                        info.setState(1);
                        break;
                    }
                    if ((flags & 0x2000000) != 0) {
                        xaRes.end(info.xid(), 0x2000000);
                        info.setState(2);
                        TransactionImple transactionImple2 = this;
                        synchronized (transactionImple2) {
                            ++this._suspendCount;
                            break;
                        }
                    }
                    xaRes.end(info.xid(), 0x20000000);
                    info.setState(3);
                    break;
                }
                case 2: {
                    if ((flags & 0x4000000) != 0) {
                        if (XAUtils.mustEndSuspendedRMs(xaRes)) {
                            xaRes.start(info.xid(), 0x8000000);
                        }
                        xaRes.end(info.xid(), 0x4000000);
                        info.setState(1);
                        TransactionImple transactionImple3 = this;
                        synchronized (transactionImple3) {
                            --this._suspendCount;
                            break;
                        }
                    }
                    if ((flags & 0x2000000) != 0) {
                        throw new IllegalStateException("TransactionImple.delistResource - " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.ressusp"));
                    }
                    xaRes.end(info.xid(), 0x20000000);
                    info.setState(3);
                    TransactionImple transactionImple4 = this;
                    synchronized (transactionImple4) {
                        --this._suspendCount;
                        break;
                    }
                }
                default: {
                    if (optimizedRollback) break;
                    throw new IllegalStateException("TransactionImple.delistResource - " + jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.illegalstate") + info.getState());
                }
            }
            info = null;
            return true;
        }
        catch (IllegalStateException ex) {
            throw ex;
        }
        catch (XAException exp) {
            if (info != null) {
                info.setState(3);
            }
            this.markRollbackOnly();
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.xaerror", new Object[]{"TransactionImple.delistResource", XAHelper.printXAErrorCode(exp)});
            }
            return false;
        }
        catch (Exception e) {
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.delistfailed", new Object[]{e});
            }
            this.markRollbackOnly();
            return false;
        }
    }

    @Override
    public final Uid get_uid() {
        return this._theTransaction.get_uid();
    }

    public String toString() {
        if (this._theTransaction == null) {
            return "TransactionImple < jts, NoTransaction >";
        }
        return "TransactionImple < jts, " + this._theTransaction.get_uid() + " >";
    }

    @Override
    public int getXAResourceState(XAResource xaRes) {
        int state = 5;
        if (xaRes != null) {
            TxInfo info = (TxInfo)this._resources.get(xaRes);
            if (info == null) {
                info = (TxInfo)this._duplicateResources.get(xaRes);
            }
            if (info != null) {
                state = info.getState();
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final TransactionImple getTransaction() {
        TransactionImple tx2 = null;
        ControlWrapper otx = OTSImpleManager.current().getControlWrapper();
        if (otx != null) {
            ConcurrentHashMap concurrentHashMap = _transactions;
            synchronized (concurrentHashMap) {
                block9: {
                    try {
                        tx2 = (TransactionImple)_transactions.get(otx.get_uid());
                        if (tx2 != null) break block9;
                        tx2 = new TransactionImple(new AtomicTransaction(otx));
                        try {
                            if (tx2.getStatus() == 0) {
                                TransactionImple.putTransaction(tx2);
                            }
                        }
                        catch (Exception ex) {}
                    }
                    catch (ClassCastException ex) {
                        if (!jtaLogger.loggerI18N.isWarnEnabled()) break block9;
                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.nottximple");
                    }
                }
            }
        }
        return tx2;
    }

    public final void shutdown() {
        TransactionImple.removeTransaction(this);
    }

    @Override
    public Object getTxLocalResource(Object key) {
        return this._txLocalResources.get(key);
    }

    @Override
    public void putTxLocalResource(Object key, Object value) {
        this._txLocalResources.put(key, value);
    }

    @Override
    public boolean isAlive() {
        return _transactions.contains(this);
    }

    protected TransactionImple(AtomicTransaction tx2) {
        block7: {
            this._theTransaction = tx2;
            if (tx2 != null) {
                this._resources = new Hashtable();
                this._duplicateResources = new Hashtable();
                this._txLocalResources = Collections.synchronizedMap(new HashMap());
            } else {
                this._resources = null;
                this._duplicateResources = null;
            }
            this._suspendCount = 0;
            try {
                if (this.getStatus() != 0) break block7;
                TwoPhaseCoordinator theTx = null;
                try {
                    theTx = (TwoPhaseCoordinator)BasicAction.Current();
                    if (theTx != null) {
                        theTx.addSynchronization(new LocalCleanupSynchronization(this));
                        break block7;
                    }
                    this.registerSynchronization(new CleanupSynchronization(this));
                }
                catch (ClassCastException ex) {
                    this.registerSynchronization(new CleanupSynchronization(this));
                }
            }
            catch (Exception ex) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.syncproblem", (Throwable)ex);
            }
        }
        this._xaTransactionTimeoutEnabled = TransactionImple.getXATransactionTimeoutEnabled();
    }

    protected void commitAndDisassociate() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, javax.transaction.SystemException, IllegalStateException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.commitAndDisassociate");
        }
        if (this._theTransaction != null) {
            try {
                this._theTransaction.commit(true);
            }
            catch (WrongTransaction wt) {
                throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.wrongstatetx"));
            }
            catch (NoTransaction e1) {
                throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.notx"));
            }
            catch (HeuristicMixed e2) {
                throw new HeuristicMixedException();
            }
            catch (HeuristicHazard e3) {
                throw new HeuristicMixedException();
            }
            catch (TRANSACTION_ROLLEDBACK e4) {
                RollbackException rollbackException = new RollbackException(e4.toString());
                if (this._rollbackOnlyCallerStacktrace != null) {
                    rollbackException.initCause(this._rollbackOnlyCallerStacktrace);
                }
                throw rollbackException;
            }
            catch (NO_PERMISSION e5) {
                throw new SecurityException();
            }
            catch (INVALID_TRANSACTION e6) {
            }
            catch (SystemException e7) {
                throw new InvalidTerminationStateException();
            }
            finally {
                TransactionImple.removeTransaction(this);
            }
        } else {
            throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.inactivetx"));
        }
    }

    protected void rollbackAndDisassociate() throws IllegalStateException, SecurityException, javax.transaction.SystemException {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.rollbackAndDisassociate");
        }
        if (this._theTransaction != null) {
            try {
                this._theTransaction.rollback();
            }
            catch (WrongTransaction e1) {
                throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.wrongstatetx"));
            }
            catch (NO_PERMISSION e2) {
                throw new SecurityException();
            }
            catch (INVALID_TRANSACTION e3) {
                throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.invalidtx2"));
            }
            catch (NoTransaction e4) {
                throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.notx"));
            }
            catch (SystemException e5) {
                throw new javax.transaction.SystemException();
            }
            finally {
                TransactionImple.removeTransaction(this);
            }
        } else {
            throw new IllegalStateException(jtaLogger.loggerI18N.getString("com.arjuna.ats.internal.jta.transaction.jts.inactivetx"));
        }
    }

    protected Xid baseXid() {
        return null;
    }

    protected static final void putTransaction(TransactionImple tx2) {
        _transactions.put(tx2.get_uid(), tx2);
    }

    protected static final void removeTransaction(TransactionImple tx2) {
        _transactions.remove(tx2.get_uid());
    }

    protected boolean endSuspendedRMs() {
        boolean result = true;
        if (this._suspendCount > 0) {
            TxInfo info;
            XAResource xaRes;
            Enumeration el = this._resources.keys();
            if (el != null) {
                try {
                    while (el.hasMoreElements()) {
                        xaRes = (XAResource)el.nextElement();
                        info = (TxInfo)this._resources.get(xaRes);
                        if (info.getState() != 2) continue;
                        if (XAUtils.mustEndSuspendedRMs(xaRes)) {
                            xaRes.start(info.xid(), 0x8000000);
                        }
                        xaRes.end(info.xid(), 0x4000000);
                        info.setState(1);
                    }
                }
                catch (XAException ex) {
                    if (jtaLogger.loggerI18N.isWarnEnabled()) {
                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.xaenderror");
                    }
                    result = false;
                }
            }
            if ((el = this._duplicateResources.keys()) != null) {
                try {
                    while (el.hasMoreElements()) {
                        xaRes = (XAResource)el.nextElement();
                        info = (TxInfo)this._duplicateResources.get(xaRes);
                        if (info.getState() != 2) continue;
                        if (XAUtils.mustEndSuspendedRMs(xaRes)) {
                            xaRes.start(info.xid(), 0x8000000);
                        }
                        xaRes.end(info.xid(), 0x4000000);
                        info.setState(1);
                    }
                }
                catch (XAException ex) {
                    if (jtaLogger.loggerI18N.isWarnEnabled()) {
                        jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.xaenderror");
                    }
                    result = false;
                }
            }
            this._suspendCount = 0;
        }
        return result;
    }

    private final boolean threadIsActive(XAResource xaRes) {
        Thread t = Thread.currentThread();
        try {
            TxInfo info;
            XAResource x;
            Enumeration el = this._resources.keys();
            if (el != null) {
                while (el.hasMoreElements()) {
                    x = (XAResource)el.nextElement();
                    if (!x.isSameRM(xaRes) || (info = (TxInfo)this._resources.get(x)).thread() != t) continue;
                    return true;
                }
            }
            if ((el = this._duplicateResources.keys()) != null) {
                while (el.hasMoreElements()) {
                    x = (XAResource)el.nextElement();
                    if (!x.isSameRM(xaRes) || (info = (TxInfo)this._resources.get(x)).thread() != t) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.threaderror", (Throwable)e);
            }
            throw new FatalError(e.toString());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TxInfo isNewRM(XAResource xaRes) {
        try {
            TransactionImple transactionImple = this;
            synchronized (transactionImple) {
                XAResource x;
                Enumeration el = this._resources.keys();
                if (el != null) {
                    while (el.hasMoreElements()) {
                        x = (XAResource)el.nextElement();
                        if (!x.isSameRM(xaRes)) continue;
                        return (TxInfo)this._resources.get(x);
                    }
                }
                if ((el = this._duplicateResources.keys()) != null) {
                    while (el.hasMoreElements()) {
                        x = (XAResource)el.nextElement();
                        if (!x.isSameRM(xaRes)) continue;
                        return (TxInfo)this._duplicateResources.get(x);
                    }
                }
            }
        }
        catch (XAException ex) {
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.xaerror", new Object[]{"TransactionImple.isNewRM", XAHelper.printXAErrorCode(ex)});
            }
            throw new FatalError(ex.toString());
        }
        catch (Exception e) {
            if (jtaLogger.loggerI18N.isWarnEnabled()) {
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.rmerror", (Throwable)e);
            }
            throw new FatalError(e.toString());
        }
        return null;
    }

    private final Xid createXid(boolean branch, XAModifier theModifier) {
        Xid jtaXid = this.baseXid();
        if (jtaXid != null) {
            return jtaXid;
        }
        try {
            XID jtsXid = this._theTransaction.get_xid(branch);
            XID tempXid = new XID();
            tempXid.formatID = jtsXid.formatID;
            tempXid.gtrid_length = jtsXid.gtrid_length;
            tempXid.bqual_length = jtsXid.bqual_length;
            System.arraycopy(jtsXid.data, 0, tempXid.data, 0, tempXid.data.length);
            jtaXid = new XidImple(tempXid);
            if (theModifier != null) {
                try {
                    jtaXid = theModifier.createXid((XidImple)jtaXid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return jtaXid;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final void markRollbackOnly() {
        block5: {
            try {
                if (this._theTransaction == null) break block5;
                try {
                    this._theTransaction.rollbackOnly();
                }
                catch (NoTransaction e3) {
                }
                catch (SystemException e3) {
                    throw new javax.transaction.SystemException();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (!jtaLogger.loggerI18N.isWarnEnabled()) break block5;
                jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.rollbackerror", new Object[]{"TransactionImple.markRollbackOnly -", ex});
            }
        }
    }

    private static boolean getXATransactionTimeoutEnabled() {
        Boolean xaTransactionTimeoutEnabled = Configuration.getXATransactionTimeoutEnabled();
        if (xaTransactionTimeoutEnabled != null) {
            return xaTransactionTimeoutEnabled;
        }
        return XA_TRANSACTION_TIMEOUT_ENABLED;
    }

    public static Map<Uid, Transaction> getTransactions() {
        return Collections.unmodifiableMap(_transactions);
    }

    @Override
    public Map<XAResource, TxInfo> getResources() {
        return Collections.unmodifiableMap(this._resources);
    }

    @Override
    public int getTimeout() {
        return this._theTransaction.getTimeout();
    }

    @Override
    public long getRemainingTimeoutMills() {
        return TransactionReaper.transactionReaper().getRemainingTimeoutMills(this._theTransaction.getControlWrapper());
    }

    @Override
    public Map<Uid, String> getSynchronizations() {
        if (this._theTransaction != null) {
            return this._theTransaction.getControlWrapper().getSynchronizations();
        }
        return Collections.EMPTY_MAP;
    }

    static {
        Class<?> lastResourceOptimisationInterface;
        block4: {
            String xaTransactionTimeoutEnabled = jtsPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.xaTransactionTimeoutEnabled");
            XA_TRANSACTION_TIMEOUT_ENABLED = xaTransactionTimeoutEnabled != null ? Boolean.valueOf(xaTransactionTimeoutEnabled) : true;
            String lastResourceOptimisationInterfaceName = jtsPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.lastResourceOptimisationInterface");
            lastResourceOptimisationInterface = null;
            if (lastResourceOptimisationInterfaceName != null) {
                try {
                    lastResourceOptimisationInterface = Thread.currentThread().getContextClassLoader().loadClass(lastResourceOptimisationInterfaceName);
                }
                catch (Throwable th) {
                    if (!jtaLogger.loggerI18N.isWarnEnabled()) break block4;
                    jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.lastResourceOptimisationInterface", new Object[]{lastResourceOptimisationInterfaceName}, th);
                }
            }
        }
        LAST_RESOURCE_OPTIMISATION_INTERFACE = lastResourceOptimisationInterface;
        String allowMultipleLastResources = jtsPropertyManager.getPropertyManager().getProperty("com.arjuna.ats.jta.allowMultipleLastResources");
        boolean bl = ALLOW_MULTIPLE_LAST_RESOURCES = allowMultipleLastResources == null ? false : Boolean.valueOf(allowMultipleLastResources);
        if (ALLOW_MULTIPLE_LAST_RESOURCES && jtaLogger.loggerI18N.isWarnEnabled()) {
            jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.jts.lastResource.startupWarning");
        }
        _transactions = new ConcurrentHashMap();
    }
}

