/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller;

import org.jboss.util.NullArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedName
implements Comparable<QualifiedName> {
    private final String qualifier;
    private final String name;

    public static QualifiedName parse(String qname) throws NullArgumentException, IllegalArgumentException {
        int index;
        if (qname == null) {
            throw new NullPointerException("No null argument accepted");
        }
        if (qname.length() > 0 && (index = qname.indexOf(58)) > -1) {
            return QualifiedName.create(qname.substring(0, index), qname.substring(index + 1));
        }
        return QualifiedName.create(qname);
    }

    public static QualifiedName create(String qualifier, String name) throws NullPointerException, IllegalArgumentException {
        return new QualifiedName(qualifier, name);
    }

    public static QualifiedName create(String name) throws NullPointerException, IllegalArgumentException {
        return new QualifiedName(name);
    }

    private QualifiedName(String name) throws NullPointerException, IllegalArgumentException {
        this("", name);
    }

    private QualifiedName(String qualifier, String name) throws NullPointerException, IllegalArgumentException {
        if (qualifier == null) {
            throw new NullPointerException("No null prefix accepted");
        }
        if (qualifier.indexOf(58) != -1) {
            throw new IllegalArgumentException("The name '" + qualifier + "' must not contain a colon character");
        }
        if (name == null) {
            throw new NullPointerException("No null prefix accepted");
        }
        if (name.indexOf(58) != -1) {
            throw new IllegalArgumentException("The name '" + name + "' must not contain a colon character");
        }
        this.qualifier = qualifier;
        this.name = name;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (this.qualifier.isEmpty()) {
            return this.name;
        }
        return this.qualifier + ":" + this.name;
    }

    public int hashCode() {
        return this.qualifier.hashCode() ^ this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QualifiedName) {
            QualifiedName that = (QualifiedName)obj;
            return this.qualifier.equals(that.qualifier) && this.name.equals(that.name);
        }
        return false;
    }

    @Override
    public int compareTo(QualifiedName o) {
        if (o == null) {
            throw new NullPointerException("No null argument accepted");
        }
        if (o == this) {
            return 0;
        }
        int qualifierComparison = this.qualifier.compareTo(o.qualifier);
        if (qualifierComparison == 0) {
            return this.name.compareTo(o.name);
        }
        return qualifierComparison;
    }

    public String toString() {
        return "QualifiedName[prefix=" + this.qualifier + ",name=" + this.name + "]";
    }
}

