jsunitRegister('testNoEvents', function testNoEvents() {
                 clearTestOutput();
                 { }
                 assertEquals('testNoEvents' + '#js', '{ }', '{ }');
                 assertEquals('testNoEvents' + '#html', '',
                              getTestOutputInnerHTML());
               });
jsunitRegister('testTextNode', function testTextNode() {
                 clearTestOutput();
                 {
                   IMPORTS___.htmlEmitter___.pc('hello world');
                 }
                 assertEquals('testTextNode' + '#js',
                              '{\n  IMPORTS___.htmlEmitter___.pc(\'hello world\');\n}',
                              '{\n  IMPORTS___.htmlEmitter___.pc(\'hello world\');\n}')
                     ;
                 assertEquals('testTextNode' + '#html', 'hello world',
                              getTestOutputInnerHTML());
               });
jsunitRegister('testSimpleElement', function testSimpleElement() {
                 clearTestOutput();
                 {
                   IMPORTS___.htmlEmitter___.b('b').f(false).ih('HELLO WORLD')
                       .e('b');
                 }
                 assertEquals('testSimpleElement' + '#js',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'b\').f(false).ih(\'HELLO WORLD\').e(\'b\');\n}',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'b\').f(false).ih(\'HELLO WORLD\').e(\'b\');\n}')
                     ;
                 assertEquals('testSimpleElement' + '#html',
                              '<b>HELLO WORLD</b>', getTestOutputInnerHTML());
               });
jsunitRegister('testEscaping', function testEscaping() {
                 clearTestOutput();
                 {
                   IMPORTS___.htmlEmitter___.b('b').f(false)
                       .ih('1 &lt; 2 &amp;&amp; 3 &gt; 2').e('b');
                 }
                 assertEquals('testEscaping' + '#js',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'b\').f(false).ih(\'1 &lt; 2 &amp;&amp; 3 &gt; 2\')\n      .e(\'b\');\n}',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'b\').f(false).ih(\'1 &lt; 2 &amp;&amp; 3 &gt; 2\')\n      .e(\'b\');\n}')
                     ;
                 assertEquals('testEscaping' + '#html',
                              '<b>1 &lt; 2 &amp;&amp; 3 &gt; 2</b>',
                              getTestOutputInnerHTML());
               });
jsunitRegister('testOptimization', function testOptimization() {
                 clearTestOutput();
                 {
                   IMPORTS___.htmlEmitter___.b('b').a('style', 'color: blue')
                       .f(false)
                       .ih('[ <a href=\"http://foo.com/\">1 &lt; 2 &amp;&amp; 3 &gt; 2</a> ]')
                       .e('b');
                 }
                 assertEquals('testOptimization' + '#js',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'b\').a(\'style\', \'color: blue\').f(false)\n      .ih(\'[ <a href=\\\"http://foo.com/\\\">1 &lt; 2 &amp;&amp; 3 &gt; 2</a> ]\')\n      .e(\'b\');\n}',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'b\').a(\'style\', \'color: blue\').f(false)\n      .ih(\'[ <a href=\\\"http://foo.com/\\\">1 &lt; 2 &amp;&amp; 3 &gt; 2</a> ]\')\n      .e(\'b\');\n}')
                     ;
                 assertEquals('testOptimization' + '#html',
                              '<b style=\"color: blue\">[ <a href=\"http://foo.com/\">1 &lt; 2 &amp;&amp; 3 &gt; 2</a> ]</b>',
                              getTestOutputInnerHTML());
});
jsunitRegister('testDeOptimization1', function testDeOptimization1() {
                 clearTestOutput();
                 {
                   IMPORTS___.htmlEmitter___.b('select').f(false).b('option')
                       .f(false).ih('1').e('option').b('option').f(false)
                       .ih('2').e('option').e('select');
                 }
                 assertEquals('testDeOptimization1' + '#js',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'select\').f(false).b(\'option\').f(false).ih(\'1\')\n      .e(\'option\').b(\'option\').f(false).ih(\'2\').e(\'option\').e(\'select\');\n}',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'select\').f(false).b(\'option\').f(false).ih(\'1\')\n      .e(\'option\').b(\'option\').f(false).ih(\'2\').e(\'option\').e(\'select\');\n}')
                     ;
                 assertEquals('testDeOptimization1' + '#html',
                              '<select><option>1</option><option>2</option></select>',
                              getTestOutputInnerHTML());
});
jsunitRegister('testDeOptimization2', function testDeOptimization2() {
                 clearTestOutput();
                 {
                   IMPORTS___.htmlEmitter___.b('table').f(false).b('tbody')
                       .f(false).b('tr').f(false).b('td').f(false).ih('1')
                       .e('td').b('td').f(false).ih('2').e('td').e('tr')
                       .e('tbody').e('table');
                 }
                 assertEquals('testDeOptimization2' + '#js',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'table\').f(false).b(\'tbody\').f(false).b(\'tr\')\n      .f(false).b(\'td\').f(false).ih(\'1\').e(\'td\').b(\'td\').f(false).ih(\'2\')\n      .e(\'td\').e(\'tr\').e(\'tbody\').e(\'table\');\n}',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'table\').f(false).b(\'tbody\').f(false).b(\'tr\')\n      .f(false).b(\'td\').f(false).ih(\'1\').e(\'td\').b(\'td\').f(false).ih(\'2\')\n      .e(\'td\').e(\'tr\').e(\'tbody\').e(\'table\');\n}')
                     ;
                 assertEquals('testDeOptimization2' + '#html',
                              '<table><tbody><tr><td>1</td><td>2</td></tr></tbody></table>',
                              getTestOutputInnerHTML());
});
jsunitRegister('testReDeOptimization1', function testReDeOptimization1() {
                 clearTestOutput();
                 {
                   IMPORTS___.htmlEmitter___.b('div').f(false)
                       .ih('<select><option>1</option><option>2</option></select>')
                       .e('div');
                 }
                 assertEquals('testReDeOptimization1' + '#js',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'div\').f(false)\n      .ih(\'<select><option>1</option><option>2</option></select>\').e(\'div\');\n}',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'div\').f(false)\n      .ih(\'<select><option>1</option><option>2</option></select>\').e(\'div\');\n}')
                     ;
                 assertEquals('testReDeOptimization1' + '#html',
                              '<div><select><option>1</option><option>2</option></select></div>',
                              getTestOutputInnerHTML());
});
jsunitRegister('testReDeOptimization2', function testReDeOptimization2() {
                 clearTestOutput();
                 {
                   IMPORTS___.htmlEmitter___.b('div').f(false)
                       .ih('<table><tbody><tr><td>1</td><td>2</td></tr></tbody></table>')
                       .e('div');
                 }
                 assertEquals('testReDeOptimization2' + '#js',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'div\').f(false)\n      .ih(\'<table><tbody><tr><td>1</td><td>2</td></tr></tbody></table>\')\n      .e(\'div\');\n}',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'div\').f(false)\n      .ih(\'<table><tbody><tr><td>1</td><td>2</td></tr></tbody></table>\')\n      .e(\'div\');\n}')
                     ;
                 assertEquals('testReDeOptimization2' + '#html',
                              '<div><table><tbody><tr><td>1</td><td>2</td></tr></tbody></table></div>',
                              getTestOutputInnerHTML());
});
jsunitRegister('testInterleaving', function testInterleaving() {
                 clearTestOutput();
                 {
                   IMPORTS___.htmlEmitter___.b('p').a('id', 'foo').f(false)
                       .ih('hello').e('p').b('p').f(false);
                   { bar(); }
                   IMPORTS___.htmlEmitter___.e('p').b('p').a('id', 'baz')
                       .f(false).ih('world').e('p');
                 }
                 assertEquals('testInterleaving' + '#js',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'p\').a(\'id\', \'foo\').f(false).ih(\'hello\').e(\'p\')\n      .b(\'p\').f(false);\n  { bar(); }\n  IMPORTS___.htmlEmitter___.e(\'p\').b(\'p\').a(\'id\', \'baz\').f(false).ih(\'world\')\n      .e(\'p\');\n}',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'p\').a(\'id\', \'foo\').f(false).ih(\'hello\').e(\'p\')\n      .b(\'p\').f(false);\n  { bar(); }\n  IMPORTS___.htmlEmitter___.e(\'p\').b(\'p\').a(\'id\', \'baz\').f(false).ih(\'world\')\n      .e(\'p\');\n}')
                     ;
                 assertEquals('testInterleaving' + '#html',
                              '<p id=\"foo\">hello</p><p></p>BAR<p id=\"baz\">world</p>',
                              getTestOutputInnerHTML());
});
jsunitRegister('testRenderingToInnerHtml', function testRenderingToInnerHtml()
               {
                 clearTestOutput();
                 {
                   IMPORTS___.htmlEmitter___.b('div').f(false)
                       .ih('<p>...On the Night&#39;s Plutonian shore!<br title=\"Quoth the &lt;raven&gt;, &#34;Nevermore.&#34;\" />Much I marvelled this ungainly fowl</p><textarea name=\"discourse\">to hear discourse so &lt;plainly&gt;</textarea>, ...')
                       .e('div');
                 }
                 assertEquals('testRenderingToInnerHtml' + '#js',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'div\').f(false)\n      .ih(\'<p>...On the Night&#39;s Plutonian shore!<br title=\\\"Quoth the &lt;raven&gt;, &quot;Nevermore.&quot;\\\" />Much I marvelled this ungainly fowl</p><textarea name=\\\"discourse\\\">to hear discourse so &lt;plainly&gt;</textarea>, ...\')\n      .e(\'div\');\n}',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'div\').f(false)\n      .ih(\'<p>...On the Night&#39;s Plutonian shore!<br title=\\\"Quoth the &lt;raven&gt;, &#34;Nevermore.&#34;\\\" />Much I marvelled this ungainly fowl</p><textarea name=\\\"discourse\\\">to hear discourse so &lt;plainly&gt;</textarea>, ...\')\n      .e(\'div\');\n}')
                     ;
                 assertEquals('testRenderingToInnerHtml' + '#html',
                              '<div><p>...On the Night\'s Plutonian shore!<br title=\"Quoth the &lt;raven&gt;, &quot;Nevermore.&quot;\">Much I marvelled this ungainly fowl</p><textarea name=\"discourse\">to hear discourse so &lt;plainly&gt;</textarea>, ...</div>',
                              getTestOutputInnerHTML());
});
jsunitRegister('testDynamicAttributes', function testDynamicAttributes() {
                 clearTestOutput();
                 {
                   IMPORTS___.htmlEmitter___.b('foo').f(false).b('bar')
                       .a('baz', 1 + 1).f(true).e('foo');
                 }
                 assertEquals('testDynamicAttributes' + '#js',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'foo\').f(false).b(\'bar\').a(\'baz\', 1 + 1).f(true)\n      .e(\'foo\');\n}',
                              '{\n  IMPORTS___.htmlEmitter___.b(\'foo\').f(false).b(\'bar\').a(\'baz\', 1 + 1).f(true)\n      .e(\'foo\');\n}')
                     ;
                 assertEquals('testDynamicAttributes' + '#html',
                              '<foo><bar baz=\"2\"></bar></foo>',
                              getTestOutputInnerHTML());
               });
