/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemCategory;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputItemSelector;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.validator.IdentifierValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;
import org.exoplatform.webui.organization.UIListPermissionSelector;
import org.exoplatform.webui.organization.UIPermissionSelector;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CheckShowActionListener.class})}), @ComponentConfig(id="CreatePortal", lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(name="Save", listeners={CreateActionListener.class}), @EventConfig(listeners={SelectItemOptionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIFormInputSet.class, id="PermissionSetting", template="system:/groovy/webui/core/UITabSelector.gtmpl", events={@EventConfig(listeners={UIFormInputSet.SelectComponentActionListener.class})})})
public class UIPortalForm
extends UIFormTabPane {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SKIN = "skin";
    private static final String FIELD_LOCALE = "locale";
    private static final String FIELD_SESSION_ALIVE = "sessionAlive";
    private static final String FIELD_SHOW_INFOBAR = "showInfobar";
    private static final String FIELD_LABEL = "label";
    private static final String FIELD_DESCRIPTION = "description";
    private String portalOwner_;
    private List<SelectItemOption<String>> languages = new ArrayList<SelectItemOption<String>>();

    public void initPortalTemplateTab() throws Exception {
        UIFormInputItemSelector uiTemplateInput = new UIFormInputItemSelector("PortalTemplate", null);
        this.addUIFormInput((UIFormInput)uiTemplateInput);
        this.setSelectedTab(uiTemplateInput.getId());
        UIFormInputSet uiPortalSetting = (UIFormInputSet)this.getChildById("PortalSetting");
        UIFormStringInput uiNameInput = uiPortalSetting.getUIStringInput(FIELD_NAME);
        uiNameInput.setEditable(true);
        this.setSelectedTab(uiPortalSetting.getId());
        this.setActions(new String[]{"Save", "Close"});
        UserPortalConfigService configService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        Set portalTemplates = configService.getPortalTemplates();
        for (String tempName : portalTemplates) {
            SelectItemCategory category = new SelectItemCategory(tempName);
            PortalConfig config = configService.getPortalConfigFromTemplate(tempName);
            if (config == null) continue;
            SelectItemOption option = new SelectItemOption(config.getLabel(), (Object)tempName, config.getDescription(), tempName);
            category.addSelectItemOption(option);
            uiTemplateInput.getItemCategories().add(category);
        }
        if (uiTemplateInput.getSelectedItemOption() == null) {
            ((SelectItemCategory)uiTemplateInput.getItemCategories().get(0)).setSelected(true);
        }
    }

    public UIPortalForm() throws Exception {
        super("UIPortalForm");
        this.createDefaultItem();
        this.setSelectedTab("PortalSetting");
    }

    public void setBindingBean() throws Exception {
        DataStorage dataStorage = (DataStorage)this.getApplicationComponent(DataStorage.class);
        UIPortal editPortal = null;
        UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
        UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)((UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace")).getChild(UIEditInlineWorkspace.class);
        if (uiPortalApp.getModeState() != 0 && uiEditWS != null && uiEditWS.getUIComponent() != null && uiEditWS.getUIComponent() instanceof UIPortal) {
            editPortal = (UIPortal)uiEditWS.getUIComponent();
        } else {
            PortalConfig pConfig = dataStorage.getPortalConfig(this.getPortalOwner());
            editPortal = (UIPortal)this.createUIComponent(UIPortal.class, null, null);
            PortalDataMapper.toUIPortal(editPortal, pConfig);
        }
        this.invokeGetBindingBean((Object)editPortal);
        ((UIFormStringInput)((UIFormInputSet)this.getChild(UIFormInputSet.class)).getChildById(FIELD_NAME)).setValue((Object)this.getPortalOwner());
        LocaleConfigService localeConfigService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        LocaleConfig localeConfig = localeConfigService.getLocaleConfig(editPortal.getLocale());
        String lang = localeConfig.getLanguage();
        if (localeConfig.getLocale().getCountry() != null && localeConfig.getLocale().getCountry().length() > 0) {
            lang = lang + "_" + localeConfig.getLocale().getCountry();
        }
        ((UIFormSelectBox)((UIFormInputSet)this.getChildById("PortalSetting")).getChildById(FIELD_LOCALE)).setValue(lang);
        this.setActions(new String[]{"Save", "Close"});
    }

    private void createDefaultItem() throws Exception {
        LocaleConfigService localeConfigService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        Collection listLocaleConfig = localeConfigService.getLocalConfigs();
        LocaleConfig defaultLocale = localeConfigService.getDefaultLocaleConfig();
        String defaultLanguage = defaultLocale.getLanguage();
        Locale currentLocale = Util.getPortalRequestContext().getLocale();
        for (LocaleConfig localeConfig : listLocaleConfig) {
            ResourceBundle localeResourceBundle = this.getResourceBundle(currentLocale);
            Locale local = localeConfig.getLocale();
            String lang = local.getLanguage();
            if (local.getCountry() != null && local.getCountry().length() > 0) {
                lang = lang + "_" + local.getCountry();
            }
            String displayName = null;
            try {
                String translation;
                String key = "Locale." + lang;
                displayName = translation = localeResourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                displayName = this.capitalizeFirstLetter(local.getDisplayName(currentLocale));
            }
            SelectItemOption option = new SelectItemOption(displayName, (Object)lang);
            if (defaultLanguage.equals(lang)) {
                option.setSelected(true);
            }
            this.languages.add((SelectItemOption<String>)option);
        }
        Collections.sort(this.languages, new LanguagesComparator());
        UIFormInputSet uiSettingSet = new UIFormInputSet("PortalSetting");
        UIFormInputSet uiPropertiesSet = new UIFormInputSet("Properties");
        uiSettingSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(IdentifierValidator.class, new Object[0]).setEditable(false)).addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_LOCALE, FIELD_LOCALE, this.languages).addValidator(MandatoryValidator.class, new Object[0]));
        uiSettingSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LABEL, FIELD_LABEL, null));
        uiSettingSet.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_DESCRIPTION, FIELD_DESCRIPTION, null));
        ArrayList<SelectItemOption> listSkin = new ArrayList<SelectItemOption>();
        SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        for (String skin : skinService.getAvailableSkinNames()) {
            SelectItemOption skinOption = new SelectItemOption(skin, (Object)skin);
            listSkin.add(skinOption);
        }
        ((SelectItemOption)listSkin.get(0)).setSelected(true);
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(FIELD_SKIN, FIELD_SKIN, listSkin);
        uiSettingSet.addUIFormInput((UIFormInput)uiSelectBox);
        this.addUIFormInput(uiSettingSet);
        ArrayList<SelectItemOption> listSessionAlive = new ArrayList<SelectItemOption>();
        listSessionAlive.add(new SelectItemOption("always", (Object)"always"));
        listSessionAlive.add(new SelectItemOption("onDemand", (Object)"onDemand"));
        listSessionAlive.add(new SelectItemOption("never", (Object)"never"));
        UIFormSelectBox uiSessionAliveBox = new UIFormSelectBox(FIELD_SESSION_ALIVE, FIELD_SESSION_ALIVE, listSessionAlive);
        uiSessionAliveBox.setValue("onDemand");
        uiPropertiesSet.addUIFormInput((UIFormInput)uiSessionAliveBox);
        UIFormCheckBoxInput uiShowInfobarBox = new UIFormCheckBoxInput(FIELD_SHOW_INFOBAR, FIELD_SHOW_INFOBAR, (Object)true);
        uiShowInfobarBox.setOnChange("CheckShowInfobar");
        uiPropertiesSet.addChild((UIComponent)uiShowInfobarBox);
        this.addUIFormInput(uiPropertiesSet);
        UIFormInputSet uiPermissionSetting = (UIFormInputSet)this.createUIComponent(UIFormInputSet.class, "PermissionSetting", null);
        this.addUIComponentInput((UIComponent)uiPermissionSetting);
        UIListPermissionSelector uiListPermissionSelector = (UIListPermissionSelector)this.createUIComponent(UIListPermissionSelector.class, null, null);
        uiListPermissionSelector.configure("UIListPermissionSelector", "accessPermissions");
        uiListPermissionSelector.addValidator(UIListPermissionSelector.EmptyIteratorValidator.class, new Object[0]);
        uiPermissionSetting.addChild((UIComponent)uiListPermissionSelector);
        uiPermissionSetting.setSelectedComponent(uiListPermissionSelector.getId());
        UIPermissionSelector uiEditPermission = (UIPermissionSelector)this.createUIComponent(UIPermissionSelector.class, null, null);
        uiEditPermission.setRendered(false);
        uiEditPermission.addValidator(UIPermissionSelector.MandatoryValidator.class, new Object[0]);
        uiEditPermission.configure("UIPermissionSelector", "editPermission");
        uiPermissionSetting.addChild((UIComponent)uiEditPermission);
    }

    public void setPortalOwner(String portalOwner) {
        this.portalOwner_ = portalOwner;
    }

    public String getPortalOwner() {
        return this.portalOwner_;
    }

    private String capitalizeFirstLetter(String word) {
        if (word == null) {
            return null;
        }
        if (word.length() == 0) {
            return word;
        }
        StringBuilder result = new StringBuilder(word);
        result.replace(0, 1, result.substring(0, 1).toUpperCase());
        return result.toString();
    }

    private ResourceBundle getResourceBundle(Locale locale) throws Exception {
        ExoContainer appContainer = ExoContainerContext.getCurrentContainer();
        ResourceBundleService service = (ResourceBundleService)appContainer.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle("locale.portal.webui", locale);
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckShowActionListener
    extends EventListener<UIPortalForm> {
        public void execute(Event<UIPortalForm> event) throws Exception {
            UIPortalForm uiForm = (UIPortalForm)((Object)event.getSource());
            UIFormInputSet InfoForm = (UIFormInputSet)uiForm.getChildById("Properties");
            UIFormCheckBoxInput showInfobarForm = InfoForm.getUIFormCheckBoxInput(UIPortalForm.FIELD_SHOW_INFOBAR);
            showInfobarForm.setValue((Object)showInfobarForm.isChecked());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectItemOptionActionListener
    extends EventListener<UIPortalForm> {
        public void execute(Event<UIPortalForm> event) throws Exception {
            UIPortalForm uiForm = (UIPortalForm)((Object)event.getSource());
            UIFormInputItemSelector templateInput = (UIFormInputItemSelector)uiForm.getChild(UIFormInputItemSelector.class);
            uiForm.setSelectedTab(templateInput.getId());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateActionListener
    extends EventListener<UIPortalForm> {
        public synchronized void execute(Event<UIPortalForm> event) throws Exception {
            UIPortalForm uiForm = (UIPortalForm)((Object)event.getSource());
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            String template = ((UIFormInputItemSelector)uiForm.getChild(UIFormInputItemSelector.class)).getSelectedItemOption().getValue().toString();
            String portalName = (String)uiForm.getUIStringInput(UIPortalForm.FIELD_NAME).getValue();
            DataStorage dataService = (DataStorage)uiForm.getApplicationComponent(DataStorage.class);
            PortalConfig config = dataService.getPortalConfig(portalName);
            if (config != null) {
                UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPortalForm.msg.sameName", null));
                return;
            }
            UserPortalConfigService service = (UserPortalConfigService)uiForm.getApplicationComponent(UserPortalConfigService.class);
            service.createUserPortalConfig(SiteType.PORTAL.getName(), portalName, template);
            PortalConfig pconfig = dataService.getPortalConfig(portalName);
            uiForm.invokeSetBindingBean(pconfig);
            dataService.save(pconfig);
            UIPortalApplication uiPortalApp = (UIPortalApplication)((UIPortalForm)((Object)event.getSource())).getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            uiMaskWS.setUIComponent(null);
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChild(UIWorkingWorkspace.class);
            uiWorkingWS.updatePortletsByName("PortalNavigationPortlet");
            uiWorkingWS.updatePortletsByName("UserToolbarSitePortlet");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPortalForm> {
        public void execute(Event<UIPortalForm> event) throws Exception {
            UIPortalForm uiForm = (UIPortalForm)((Object)event.getSource());
            DataStorage dataService = (DataStorage)uiForm.getApplicationComponent(DataStorage.class);
            UserACL acl = (UserACL)uiForm.getApplicationComponent(UserACL.class);
            PortalRequestContext prContext = Util.getPortalRequestContext();
            UIPortalApplication uiPortalApp = (UIPortalApplication)prContext.getUIApplication();
            PortalConfig pConfig = dataService.getPortalConfig(uiForm.getPortalOwner());
            if (pConfig != null && acl.hasPermission(pConfig)) {
                UIPortal uiPortal = (UIPortal)uiForm.createUIComponent(UIPortal.class, null, null);
                PortalDataMapper.toUIPortal(uiPortal, pConfig);
                uiForm.invokeSetBindingBean((Object)uiPortal);
                if (uiPortalApp.getModeState() == 0) {
                    PortalConfig portalConfig = (PortalConfig)PortalDataMapper.buildModelObject((UIComponent)uiPortal);
                    dataService.save(portalConfig);
                    UserPortalConfigService service = (UserPortalConfigService)uiForm.getApplicationComponent(UserPortalConfigService.class);
                    if (prContext.getPortalOwner().equals(uiForm.getPortalOwner())) {
                        uiPortalApp.setUserPortalConfig(service.getUserPortalConfig(uiForm.getPortalOwner(), prContext.getRemoteUser(), PortalRequestContext.USER_PORTAL_CONTEXT));
                        uiPortalApp.reloadPortalProperties();
                    }
                    UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChild(UIWorkingWorkspace.class);
                    uiWorkingWS.updatePortletsByName("PortalNavigationPortlet");
                    uiWorkingWS.updatePortletsByName("UserToolbarSitePortlet");
                } else {
                    UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.findFirstComponentOfType(UIWorkingWorkspace.class);
                    UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)uiWorkingWS.getChild(UIEditInlineWorkspace.class);
                    UIPortal editPortal = (UIPortal)uiEditWS.getUIComponent();
                    uiForm.invokeSetBindingBean((Object)editPortal);
                }
            } else {
                UIApplication uiApp = Util.getPortalRequestContext().getUIApplication();
                uiApp.addMessage(new ApplicationMessage("UIPortalForm.msg.notExistAnymore", null));
                UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
                prContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                prContext.setFullRender(true);
            }
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiForm.getParent();
            uiMaskWorkspace.setUIComponent(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWorkspace);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LanguagesComparator
    implements Comparator<SelectItemOption> {
        private LanguagesComparator() {
        }

        @Override
        public int compare(SelectItemOption o1, SelectItemOption o2) {
            return o1.getLabel().compareToIgnoreCase(o2.getLabel());
        }
    }
}

