/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.BooleanOperations;
import de.odysseus.el.misc.NumberOperations;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import javax.el.ELContext;

public class AstBinary
extends AstRightValue {
    public static final Operator ADD = new Operator(){

        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return NumberOperations.add(converter, o1, o2);
        }

        public String toString() {
            return "+";
        }
    };
    public static final Operator AND = new Operator(){

        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.and(converter, o1, o2);
        }

        public String toString() {
            return "&&";
        }
    };
    public static final Operator DIV = new Operator(){

        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return NumberOperations.div(converter, o1, o2);
        }

        public String toString() {
            return "/";
        }
    };
    public static final Operator EQ = new Operator(){

        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.eq(converter, o1, o2);
        }

        public String toString() {
            return "==";
        }
    };
    public static final Operator GE = new Operator(){

        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.ge(converter, o1, o2);
        }

        public String toString() {
            return ">=";
        }
    };
    public static final Operator GT = new Operator(){

        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.gt(converter, o1, o2);
        }

        public String toString() {
            return ">";
        }
    };
    public static final Operator LE = new Operator(){

        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.le(converter, o1, o2);
        }

        public String toString() {
            return "<=";
        }
    };
    public static final Operator LT = new Operator(){

        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.lt(converter, o1, o2);
        }

        public String toString() {
            return "<";
        }
    };
    public static final Operator MOD = new Operator(){

        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return NumberOperations.mod(converter, o1, o2);
        }

        public String toString() {
            return "%";
        }
    };
    public static final Operator MUL = new Operator(){

        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return NumberOperations.mul(converter, o1, o2);
        }

        public String toString() {
            return "*";
        }
    };
    public static final Operator NE = new Operator(){

        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.ne(converter, o1, o2);
        }

        public String toString() {
            return "!=";
        }
    };
    public static final Operator OR = new Operator(){

        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return BooleanOperations.or(converter, o1, o2);
        }

        public String toString() {
            return "||";
        }
    };
    public static final Operator SUB = new Operator(){

        public Object apply(TypeConverter converter, Object o1, Object o2) {
            return NumberOperations.sub(converter, o1, o2);
        }

        public String toString() {
            return "-";
        }
    };
    private final Operator operator;
    private final AstNode left;
    private final AstNode right;

    public AstBinary(AstNode left, AstNode right, Operator operator) {
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Object eval(Bindings bindings, ELContext context) {
        return this.operator.apply(bindings, this.left.eval(bindings, context), this.right.eval(bindings, context));
    }

    public String toString() {
        return "'" + this.operator.toString() + "'";
    }

    public void appendStructure(StringBuilder b, Bindings bindings) {
        this.left.appendStructure(b, bindings);
        b.append(' ');
        b.append(this.operator);
        b.append(' ');
        this.right.appendStructure(b, bindings);
    }

    public int getCardinality() {
        return 2;
    }

    public AstNode getChild(int i) {
        return i == 0 ? this.left : (i == 1 ? this.right : null);
    }

    public static interface Operator {
        public Object apply(TypeConverter var1, Object var2, Object var3);
    }
}

