/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.ArrayList;
import java.util.Collection;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.impl.MembershipImpl;
import org.exoplatform.services.organization.ldap.ADSearchBySID;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;
import org.exoplatform.services.organization.ldap.MembershipDAOImpl;

public class ADMembershipDAOImpl
extends MembershipDAOImpl {
    private ADSearchBySID adSearch;

    public ADMembershipDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, ADSearchBySID ad, OrganizationService service) throws Exception {
        super(ldapAttrMapping, ldapService, service);
        this.adSearch = ad;
    }

    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        LdapContext ctx = this.ldapService.getLdapContext(true);
        String groupDN = this.getGroupDNFromGroupId(groupId);
        try {
            int err = 0;
            while (true) {
                try {
                    Collection memberships = this.findMemberships(ctx, userName, groupDN, type);
                    if (memberships.size() > 0) {
                        MembershipImpl membershipImpl = (MembershipImpl)memberships.iterator().next();
                        return membershipImpl;
                    }
                    Membership membership = null;
                    return membership;
                }
                catch (NamingException e) {
                    if (!ADMembershipDAOImpl.isConnectionError(e) || err >= ADMembershipDAOImpl.getMaxConnectionError()) {
                        throw e;
                    }
                    ctx = this.ldapService.getLdapContext(true);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    public Collection findMembershipsByUser(String userName) throws Exception {
        LdapContext ctx = this.ldapService.getLdapContext(true);
        try {
            int err = 0;
            while (true) {
                try {
                    Collection collection = this.findMemberships(ctx, userName, this.ldapAttrMapping.groupsURL, null);
                    return collection;
                }
                catch (NamingException e) {
                    if (!ADMembershipDAOImpl.isConnectionError(e) || err >= ADMembershipDAOImpl.getMaxConnectionError()) {
                        throw e;
                    }
                    ctx = this.ldapService.getLdapContext(true);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    public Collection findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
        String groupDN = this.getGroupDNFromGroupId(groupId);
        LdapContext ctx = this.ldapService.getLdapContext(true);
        try {
            int err = 0;
            while (true) {
                try {
                    Collection collection = this.findMemberships(ctx, userName, groupDN, null);
                    return collection;
                }
                catch (NamingException e) {
                    if (!ADMembershipDAOImpl.isConnectionError(e) || err >= ADMembershipDAOImpl.getMaxConnectionError()) {
                        throw e;
                    }
                    ctx = this.ldapService.getLdapContext(true);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection findMemberships(LdapContext ctx, String userName, String groupId, String type) throws Exception {
        ArrayList<Membership> list = new ArrayList<Membership>();
        String userDN = this.getDNFromUsername(ctx, userName);
        if (userDN == null) {
            return list;
        }
        String filter = this.ldapAttrMapping.userObjectClassFilter;
        String[] retAttrs = new String[]{"tokenGroups"};
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(0);
        constraints.setReturningAttributes(retAttrs);
        NamingEnumeration<SearchResult> results = null;
        try {
            results = ctx.search(userDN, filter, constraints);
            while (results.hasMore()) {
                SearchResult sr = results.next();
                Attributes attrs = sr.getAttributes();
                Attribute attr = attrs.get("tokenGroups");
                for (int x = 0; x < attr.size(); ++x) {
                    byte[] SID = (byte[])attr.get(x);
                    String membershipDN = this.adSearch.findMembershipDNBySID(ctx, SID, groupId, type);
                    if (membershipDN == null) continue;
                    list.add(this.createMembershipObject(ctx, membershipDN, userName, type));
                }
            }
            ArrayList<Membership> arrayList = list;
            return arrayList;
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    private Membership createMembershipObject(LdapContext ctx, String dn, String user, String type) throws Exception {
        Group group = this.getGroupFromMembershipDN(ctx, dn);
        if (type == null) {
            type = this.explodeDN(dn, true)[0];
        }
        MembershipImpl membership = new MembershipImpl();
        membership.setId(user + "," + type + "," + group.getId());
        membership.setUserName(user);
        membership.setMembershipType(type);
        membership.setGroupId(group.getId());
        return membership;
    }
}

