/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.chromattic.api.ChromatticBuilder;
import org.chromattic.api.format.DefaultObjectFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromatticBuilderConfigurationFactoryImpl
extends ChromatticBuilder.Configuration.Factory {
    private static final Set<ChromatticBuilder.Option> SYSTEM_OPTIONS = Collections.unmodifiableSet(new HashSet<ChromatticBuilder.Option>(Arrays.asList(ChromatticBuilder.PROPERTY_CACHE_ENABLED, ChromatticBuilder.PROPERTY_READ_AHEAD_ENABLED, ChromatticBuilder.JCR_OPTIMIZE_ENABLED, ChromatticBuilder.JCR_OPTIMIZE_HAS_PROPERTY_ENABLED, ChromatticBuilder.JCR_OPTIMIZE_HAS_NODE_ENABLED, ChromatticBuilder.SESSION_LIFECYCLE_CLASSNAME)));
    private static final ChromatticBuilder.Configuration DEFAULT_CONFIG;

    private static <D> void _set(ChromatticBuilder.Configuration config, ChromatticBuilder.Option<D> option, String value, boolean overwrite) throws NullPointerException {
        config.setOptionValue(option, option.getType().parse(value), overwrite);
    }

    public ChromatticBuilder.Configuration create() {
        return new ChromatticBuilder.Configuration(DEFAULT_CONFIG);
    }

    static {
        ChromatticBuilder.Configuration config = new ChromatticBuilder.Configuration();
        if (!Boolean.FALSE.equals(config.getOptionValue(ChromatticBuilder.USE_SYSTEM_PROPERTIES))) {
            for (ChromatticBuilder.Option option : SYSTEM_OPTIONS) {
                String value = System.getProperty(option.getName());
                if (value == null) continue;
                ChromatticBuilderConfigurationFactoryImpl._set(config, option, value, false);
            }
        }
        config.setOptionValue(ChromatticBuilder.INSTRUMENTOR_CLASSNAME, (Object)"org.chromattic.apt.InstrumentorImpl", false);
        config.setOptionValue(ChromatticBuilder.SESSION_LIFECYCLE_CLASSNAME, (Object)"org.chromattic.exo.ExoSessionLifeCycle", false);
        config.setOptionValue(ChromatticBuilder.OBJECT_FORMATTER_CLASSNAME, (Object)DefaultObjectFormatter.class.getName(), false);
        config.setOptionValue(ChromatticBuilder.PROPERTY_CACHE_ENABLED, (Object)false, false);
        config.setOptionValue(ChromatticBuilder.PROPERTY_READ_AHEAD_ENABLED, (Object)false, false);
        config.setOptionValue(ChromatticBuilder.JCR_OPTIMIZE_HAS_PROPERTY_ENABLED, (Object)false, false);
        config.setOptionValue(ChromatticBuilder.JCR_OPTIMIZE_HAS_NODE_ENABLED, (Object)false, false);
        config.setOptionValue(ChromatticBuilder.ROOT_NODE_PATH, (Object)"/", false);
        config.setOptionValue(ChromatticBuilder.CREATE_ROOT_NODE, (Object)false, false);
        config.setOptionValue(ChromatticBuilder.LAZY_CREATE_ROOT_NODE, (Object)false, false);
        DEFAULT_CONFIG = config;
    }
}

